'use strict';

Liferay.Loader.define('frontend-taglib-chart$clay-charts@2.15.1/lib/RadarChart', ['module', 'exports', 'require', './Chart', 'frontend-js-metal-web$metal-soy', './RadarChart.soy', './utils/types', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.RadarChart = undefined;

	var _Chart2 = require('./Chart');

	var _Chart3 = _interopRequireDefault(_Chart2);

	var _metalSoy = require('frontend-js-metal-web$metal-soy');

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _RadarChartSoy = require('./RadarChart.soy');

	var _RadarChartSoy2 = _interopRequireDefault(_RadarChartSoy);

	var _types = require('./utils/types');

	var _types2 = _interopRequireDefault(_types);

	var _metalState = require('frontend-js-metal-web$metal-state');

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Radar Chart Component
  * @augments Chart
  */
	var RadarChart = function (_Chart) {
		_inherits(RadarChart, _Chart);

		function RadarChart() {
			_classCallCheck(this, RadarChart);

			return _possibleConstructorReturn(this, (RadarChart.__proto__ || Object.getPrototypeOf(RadarChart)).apply(this, arguments));
		}

		return RadarChart;
	}(_Chart3.default);

	RadarChart.STATE = {
		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof RadarChart
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * Labels visibility
   * @default true
   * @instance
   * @memberof RadarChart
   * @type {Boolean}
   */
		labels: _metalState.Config.bool().value(true),

		/**
   * Set radar options
   * @default undefined
   * @instance
   * @memberof RadarChart
   * @type {?Object}
   *
   */
		radar: _metalState.Config.shapeOf({
			axis: _metalState.Config.shapeOf({
				line: _metalState.Config.shapeOf({
					show: _metalState.Config.bool()
				}),
				max: _metalState.Config.number(),
				text: _metalState.Config.shapeOf({
					show: _metalState.Config.bool()
				})
			}),
			level: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				text: _metalState.Config.shapeOf({
					format: _metalState.Config.func(),
					show: _metalState.Config.bool()
				})
			}),
			size: _metalState.Config.shapeOf({
				ratio: _metalState.Config.number()
			})
		}),

		/**
   * The variety of chart that will be rendered.
   * @default radar
   * @instance
   * @memberof AreaLineChart
   * @type {?(string|undefined)}
   */
		type: _metalState.Config.oneOf(_types2.default.radar).value('radar')
	};

	_metalSoy2.default.register(RadarChart, _RadarChartSoy2.default);

	exports.RadarChart = RadarChart;
	exports.default = RadarChart;
	//# sourceMappingURL=RadarChart.js.map
});
//# sourceMappingURL=RadarChart.js.map