'use strict';

Liferay.Loader.define("frontend-taglib-chart$clay-charts@2.15.1/lib/PredictiveChart", ['module', 'exports', 'require', './Chart', 'frontend-js-metal-web$metal-soy', './PredictiveChart.soy', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.PredictiveChart = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _Chart2 = require('./Chart');

	var _Chart3 = _interopRequireDefault(_Chart2);

	var _metalSoy = require("frontend-js-metal-web$metal-soy");

	var _metalSoy2 = _interopRequireDefault(_metalSoy);

	var _PredictiveChartSoy = require("./PredictiveChart.soy");

	var _PredictiveChartSoy2 = _interopRequireDefault(_PredictiveChartSoy);

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metal = require("frontend-js-metal-web$metal");

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var DEFAULT_AXIS_X = {
		tick: {
			culling: {
				max: 1
			},
			fit: true,
			format: '%Y-%m-%d'
		},
		type: 'timeseries'
	};

	var DEFAULT_TOOLTIP = {
		contents: function contents(data, defaultTitleFormat, defaultValueFormat, colorFn) {
			var datum = data[0];
			var color = colorFn(datum);
			var title = defaultTitleFormat(datum.x);
			var value = (0, _metal.isObject)(datum.value) && datum.value.hasOwnProperty('mid') ? datum.value.mid : Array.isArray(datum.value) ? datum.value[1] : datum.value;

			return '<table class="bb-tooltip">\n\t\t\t<tbody>\n\t\t\t\t<tr><th colspan="2">' + title + '</th></tr>\n\t\t\t\t<tr class="bb-tooltip-name-data1">\n\t\t\t\t\t<td class="name">\n\t\t\t\t\t\t<span style="background-color:' + color + '"></span>' + datum.id + '\n\t\t\t\t\t</td>\n\t\t\t\t\t<td class="value">' + value + '</td>\n\t\t\t\t</tr>\n\t\t\t</tbody>\n\t\t</table>';
		},

		grouped: false
	};

	/**
  * Predictive Chart component.
  * @augments Chart
  */

	var PredictiveChart = function (_Chart) {
		_inherits(PredictiveChart, _Chart);

		function PredictiveChart() {
			_classCallCheck(this, PredictiveChart);

			return _possibleConstructorReturn(this, (PredictiveChart.__proto__ || Object.getPrototypeOf(PredictiveChart)).apply(this, arguments));
		}

		_createClass(PredictiveChart, [{
			key: 'attached',

			/**
    * @inheritDoc
    */
			value: function attached() {
				_get(PredictiveChart.prototype.__proto__ || Object.getPrototypeOf(PredictiveChart.prototype), 'attached', this).call(this);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'created',
			value: function created() {
				var config = this.getInitialConfig();

				if ((0, _metal.isDefAndNotNull)(config.timeseries)) {
					config.data.push({ data: config.timeseries, id: 'x' });
				}

				if ((0, _metal.isDefAndNotNull)(this.data)) {
					this._normalizeData();
				}

				if ((0, _metal.isDefAndNotNull)(this.axisXTickFormat)) {
					this.axisX.tick.format = this.axisXTickFormat;
				}

				if ((0, _metal.isDefAndNotNull)(this.predictionDate)) {
					if ((0, _metal.isString)(this.predictionDate)) {
						this.predictionDate = new Date(this.predictionDate);
					}

					if (!(0, _metal.isDefAndNotNull)(this.regions)) {
						this.regions = [];
					}

					this.regions.push({
						axis: 'x',
						start: this.predictionDate
					});
				}

				if ((0, _metal.isDefAndNotNull)(this.tooltipContents)) {
					this.tooltip.contents = this.tooltipContents;
				}
			}

			/**
    * Normalizes the data.
    * @memberof PredictiveChart
    * @private
    */

		}, {
			key: '_normalizeData',
			value: function _normalizeData() {
				this.data = this.data.map(function (dataSeries) {
					if (dataSeries.id !== 'x') {
						dataSeries.data = dataSeries.data.map(function (element) {
							return (0, _metal.isNumber)(element) ? { low: element, mid: element, high: element } : element;
						});
					}

					return dataSeries;
				});
			}
		}]);

		return PredictiveChart;
	}(_Chart3.default);

	PredictiveChart.STATE = {
		/**
   * X axis configuration.
   * @default DEFAULT_AXIS_X
   * @instance
   * @memberof PredictiveChart
   * @type {Object}
   */
		axisX: _metalState.Config.shapeOf({
			tick: _metalState.Config.shapeOf({
				culling: _metalState.Config.shapeOf({
					max: _metalState.Config.number().required()
				}),
				fit: _metalState.Config.bool(),
				format: _metalState.Config.oneOfType([_metalState.Config.func(), _metalState.Config.string()])
			}),
			type: _metalState.Config.oneOf(['timeseries']).required()
		}).value(DEFAULT_AXIS_X),

		/**
   * The axisX tick format configuration.
   * This can be a function or a string.
   *
   * For more information on the supported formats, please
   * see https://github.com/d3/d3-time-format
   *
   * @default '%Y-%m-%d'
   * @instance
   * @memberof PredictiveChart
   * @type {Function|String}
   */
		axisXTickFormat: _metalState.Config.oneOfType([_metalState.Config.func(), _metalState.Config.string()]),

		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof PredictiveChart
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * The prediction date used to define the <code>region</code>
   * on the X axis.
   * @default undefined
   * @instance
   * @memberof PredictiveChart
   * @type {Date}
   */
		predictionDate: {
			validator: function validator(val) {
				return val instanceof Date || (0, _metal.isString)(val);
			}
		},

		/**
   * The timeseries configuration
   * @default undefined
   * @instance
   * @memberof PredictiveChart
   * @type {Array}
   */
		timeseries: _metalState.Config.array(),

		/**
   * Toolip configuration.
   * @default DEFAULT_TOOLTIP
   * @instance
   * @memberof PredictiveChart
   * @type {Date}
   */
		tooltip: _metalState.Config.shapeOf({
			contents: _metalState.Config.func(),
			grouped: _metalState.Config.bool()
		}).value(DEFAULT_TOOLTIP),

		/**
   * Tooltip format title function
   * @default undefined
   * @instance
   * @memberof PredictiveChart
   * @type {Function}
   */
		tooltipContents: _metalState.Config.func(),

		/**
   * The variety of chart that will be rendered.
   * @default area-line-range
   * @instance
   * @memberof PredictiveChart
   * @type {string}
   */
		type: _metalState.Config.oneOf(['area-line-range', 'area-spline-range']).value('area-line-range'),

		/**
   * X configuration
   * @default x
   * @instance
   * @memberof PredictiveChart
   * @type {string}
   */
		x: _metalState.Config.oneOf(['x']).value('x')
	};

	_metalSoy2.default.register(PredictiveChart, _PredictiveChartSoy2.default);

	exports.PredictiveChart = PredictiveChart;
	exports.default = PredictiveChart;
	//# sourceMappingURL=PredictiveChart.js.map
});
//# sourceMappingURL=PredictiveChart.js.map