'use strict';

Liferay.Loader.define("frontend-taglib-chart$clay-charts@2.15.1/lib/Geomap", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './Geomap.soy', 'frontend-js-metal-web$metal-state', 'frontend-taglib-chart$clay-charts-shared'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Geomap = undefined;

  var _createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
    };
  }();

  var _metalComponent = require("frontend-js-metal-web$metal-component");

  var _metalComponent2 = _interopRequireDefault(_metalComponent);

  var _metalSoy = require("frontend-js-metal-web$metal-soy");

  var _metalSoy2 = _interopRequireDefault(_metalSoy);

  var _GeomapSoy = require("./Geomap.soy");

  var _GeomapSoy2 = _interopRequireDefault(_GeomapSoy);

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayChartsShared = require("frontend-taglib-chart$clay-charts-shared");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  /**
   * Geomap component
   */
  var Geomap = function (_Component) {
    _inherits(Geomap, _Component);

    function Geomap() {
      _classCallCheck(this, Geomap);

      return _possibleConstructorReturn(this, (Geomap.__proto__ || Object.getPrototypeOf(Geomap)).apply(this, arguments));
    }

    _createClass(Geomap, [{
      key: 'attached',

      /**
       * @inheritDoc
       */
      value: function attached() {
        var config = this.getInitialConfig();

        this._geoMapInstance = new _clayChartsShared.geomap.Geomap(Object.assign({
          element: this.element
        }, config));

        this._geoMapInstance.attached();
      }

      /**
       * @inheritDoc
       */

    }, {
      key: 'disposed',
      value: function disposed() {
        this._geoMapInstance.disposed();
      }
    }]);

    return Geomap;
  }(_metalComponent2.default);

  _metalSoy2.default.register(Geomap, _GeomapSoy2.default);

  /**
   * GeoMap state definition.
   * @type {!Object}
   * @static
   */
  Geomap.STATE = {
    /**
     * Minimum value for domain
     * @instance
     * @memberof Geomap
     * @type {!Number}
     */
    _domainMin: _metalState.Config.number().internal(),

    /**
     * Maximum value for domain
     * @instance
     * @memberof Geomap
     * @type {!Number}
     */
    _domainMax: _metalState.Config.number().internal(),

    /**
     * Height of the map
     * @default 480
     * @instance
     * @memberof Geomap
     * @type {?Number}
     */
    _height: _metalState.Config.oneOfType([_metalState.Config.string(), _metalState.Config.number()]).value('100%').internal(),

    /**
     * Width of the map
     * @default 640
     * @instance
     * @memberof Geomap
     * @type {?Number}
     */
    _width: _metalState.Config.oneOfType([_metalState.Config.string(), _metalState.Config.number()]).value('100%').internal(),

    /**
     * Color configuration.
     * @default undefined
     * @instance
     * @memberof ChartBase
     * @type {?Object}
     */
    color: _metalState.Config.shapeOf({
      range: _metalState.Config.shapeOf({
        max: _metalState.Config.string().required(),
        min: _metalState.Config.string().required()
      }),
      selected: _metalState.Config.string(),
      value: _metalState.Config.string().required()
    }).value({
      range: {
        min: '#b1d4ff',
        max: '#0065e4'
      },
      selected: '#4b9bff',
      value: 'pop_est'
    }),

    /**
     * Data that will be rendered to the chart.
     * @default undefined
     * @instance
     * @memberof ChartBase
     * @type {?(Array|undefined)}
     */
    data: _metalState.Config.oneOfType([_metalState.Config.object(), _metalState.Config.func(), _metalState.Config.string()]),

    /**
     * Id to be applied to the element.
     * @default undefined
     * @instance
     * @memberof Geomap
     * @type {?(string|undefined)}
     */
    id: _metalState.Config.string(),

    /**
     * Set an interval (in ms) to fetch the data.
     * @default undefined
     * @instance
     * @memberof ChartBase
     * @type {?Number}
     */
    pollingInterval: _metalState.Config.number()
  };

  exports.Geomap = Geomap;
  exports.default = Geomap;
  //# sourceMappingURL=Geomap.js.map
});
//# sourceMappingURL=Geomap.js.map