'use strict';

Liferay.Loader.define('frontend-taglib-chart$clay-charts@2.15.1/lib/ChartBase', ['module', 'exports', 'require', 'frontend-taglib-chart$billboard.js', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal', 'frontend-taglib-chart$clay-charts-shared', './utils/types', 'frontend-taglib-chart$d3'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ChartBase = exports.d3 = exports.bb = undefined;

	var _billboard = require('frontend-taglib-chart$billboard.js');

	var _metalState = require('frontend-js-metal-web$metal-state');

	var _metal = require('frontend-js-metal-web$metal');

	var _clayChartsShared = require('frontend-taglib-chart$clay-charts-shared');

	var _types = require('./utils/types');

	var _types2 = _interopRequireDefault(_types);

	var _d = require('frontend-taglib-chart$d3');

	var d3 = _interopRequireWildcard(_d);

	function _interopRequireWildcard(obj) {
		if (obj && obj.__esModule) {
			return obj;
		} else {
			var newObj = {};if (obj != null) {
				for (var key in obj) {
					if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
				}
			}newObj.default = obj;return newObj;
		}
	}

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	var resolveData = _clayChartsShared.data.resolveData;
	var DEFAULT_COLORS = _clayChartsShared.config.DEFAULT_COLORS,
	    DEFAULT_GRID_OBJECT = _clayChartsShared.config.DEFAULT_GRID_OBJECT,
	    DEFAULT_LINE_CLASSES = _clayChartsShared.config.DEFAULT_LINE_CLASSES,
	    DEFAULT_POINT_PATTERNS = _clayChartsShared.config.DEFAULT_POINT_PATTERNS,
	    DEFAULT_TILES = _clayChartsShared.config.DEFAULT_TILES;

	var PROP_NAME_MAP = {
		axis: 'axes',
		class: 'classes',
		color: 'colors',
		name: 'names',
		regions: 'regions',
		type: 'types'
	};

	/**
  * Chart Base prototype.
  * @class ChartBase
  *
  * @mixin
  */
	var ChartBase = {
		/**
   * @inheritDoc
   * @memberof ChartBase
   */
		attached: function attached() {
			var _this = this;

			if ((0, _metal.isServerSide)()) {
				return;
			}

			this._addEventListeners();

			var config = this.getInitialConfig();
			var data = (0, _metal.isDefAndNotNull)(config.columns) ? config.columns : config.data;

			if (!data) {
				return;
			}

			resolveData(data).then(function (data) {
				_this._resolvedData = data;

				if ((0, _metal.isDefAndNotNull)(_this.props) && (0, _metal.isDefAndNotNull)(_this.props._loading)) {
					_this.props._loading = false;
				} else {
					_this._loading = false;
				}

				if (!(0, _metal.isDefAndNotNull)(data)) {
					_this.emit('chartError', new Error('unable to load Chart data.'));
					return;
				}

				_this._setupPolling();

				var config = _this._constructChartConfig();
				_this.bbChart = _billboard.bb.generate(config);
				_this.emit('chartReady');
			}).catch(function (err) {
				_this.emit('chartError', err);
			});
		},

		/**
   * @inheritDoc
   * @memberof ChartBase
   */
		disposed: function disposed() {
			if ((0, _metal.isServerSide)()) {
				return;
			}

			if (this._pollingInterval) {
				clearInterval(this._pollingInterval);
				this._pollingInterval = null;
			}

			if (this.bbChart) {
				this.bbChart.destroy();
			}
		},

		/**
   * Adds event listeners
   * @memberof ChartBase
   * @protected
   */
		_addEventListeners: function _addEventListeners() {
			this.on('dataChanged', this._handleDataChanged.bind(this));
			this.on('groupsChanged', this._handleGroupsChanged.bind(this));
			this.on('_loadingChanged', this._handleLoadingChanged.bind(this));
			this.on('regionsChanged', this._handleRegionsChanged.bind(this));
			this.on('sizeChanged', this._handleSizeChanged.bind(this));
			this.on('typeChanged', this._handleTypeChanged.bind(this));
			this.on('xChanged', this._handleXChanged.bind(this));
		},

		/**
   * @inheritDoc
   * @memberof ChartBase
   */
		shouldUpdate: function shouldUpdate() {
			return false;
		},

		/**
   * Constructs `axis` billboard config property.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructAxisConfig: function _constructAxisConfig() {
			var state = this._getStateObj();

			return {
				rotated: state.axisRotated,
				x: state.axisX,
				y2: state.axisY2,
				y: state.axisY
			};
		},

		/**
   * Constructs config object for `bb.generate` method.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructChartConfig: function _constructChartConfig() {
			var state = this._getStateObj();
			var axis = this._constructAxisConfig();
			var data = this._constructDataConfig();
			var zoom = this._constructZoomConfig();
			var color = this._constructTilesConfig();

			var config = {
				area: state.area,
				axis: axis,
				bar: state.bar,
				bindto: this.element.querySelector('[ref="chart"]'),
				bubble: state.bubble,
				color: color,
				data: data,
				donut: state.donut,
				gauge: state.gauge,
				grid: state.grid,
				legend: state.legend,
				line: state.line,
				loading: state.loading,
				padding: state.padding,
				pie: state.pie,
				point: state.point,
				regions: state.regions,
				resize: state.resizeAuto,
				size: state.size,
				spline: state.splineInterpolationType,
				subchart: state.subchart,
				svg: state.svgClassname,
				title: state.title,
				tooltip: state.tooltip,
				transition: state.transitionDuration,
				zoom: zoom
			};

			/**
    * Chart init event.
    * @event chartInit
    * @memberof ChartBase
    */
			config.oninit = this._emitChartEvent.bind(this, 'chartInit');
			/**
    * Chart mouse out event.
    * @event chartMouseout
    * @memberof ChartBase
    */
			config.onout = this._emitChartEvent.bind(this, 'chartMouseout');
			/**
    * Chart mouse over event.
    * @event chartMouseover
    * @memberof ChartBase
    */
			config.onover = this._emitChartEvent.bind(this, 'chartMouseover');
			/**
    * Chart rendered event.
    * @event chartRendered
    * @memberof ChartBase
    */
			config.onrendered = this._emitChartEvent.bind(this, 'chartRendered');
			/**
    * Chart resize event.
    * @event chartResize
    * @memberof ChartBase
    */
			config.onresize = this._emitChartEvent.bind(this, 'chartResize');
			/**
    * Chart resized event.
    * @event chartResized
    * @memberof ChartBase
    */
			config.onresized = this._emitChartEvent.bind(this, 'chartResized');

			return config;
		},

		/**
   * Constructs various `data` billboard properties from `data` state.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructChartDataConfig: function _constructChartDataConfig() {
			var data = this._resolvedData;
			var config = {
				columns: this._createDataArray(data)
			};

			for (var i = 0; i < data.length; i++) {
				var column = data[i];

				var id = column.id;

				var keys = Object.keys(column);

				for (var j = 0; j < keys.length; j++) {
					var key = keys[j];

					if (key === 'data' || key === 'id') {
						continue;
					}

					if (key === 'hide') {
						config.hide = config.hide || [];

						if (column.hide) {
							config.hide.push(column.id);
						}
					} else {
						// eslint-disable-next-line
						config[PROP_NAME_MAP[key]] = config[PROP_NAME_MAP[key]] || {};

						config[PROP_NAME_MAP[key]][id] = column[key];
					}
				}
			}

			return config;
		},

		/**
   * When tiles for true always leave `colors` empty,
   * this ensures that` colors.tiles` is more important.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructColorsConfig: function _constructColorsConfig() {
			var _getStateObj = this._getStateObj(),
			    colors = _getStateObj.colors,
			    color = _getStateObj.color;

			if (color && color.tiles) {
				colors = {};
			}

			return colors;
		},

		/**
   * Constructs `data` billboard config property.
   * @memberof ChartBase
   * @param {boolean} attachListeners
   * @protected
   * @return {Object}
   */
		_constructDataConfig: function _constructDataConfig() {
			var attachListeners = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

			var state = this._getStateObj();
			var colors = this._constructColorsConfig();
			var config = {
				color: state.colorFormatter,
				colors: colors,
				empty: state.emptyLabelText,
				groups: state.groups,
				hide: state.hide,
				json: state.json,
				keys: state.keys,
				labels: state.labels,
				mimeType: state.mimeType,
				order: state.order,
				rows: state.rows,
				selection: state.selection,
				type: state.type,
				url: state.url,
				x: state.x,
				xFormat: state.xFormat,
				xLocaltime: state.xLocaltime,
				xSort: state.xSort,
				xs: state.xs
			};

			var dataConfig = this._constructChartDataConfig();

			Object.assign(config, dataConfig);

			if (attachListeners) {
				/**
     * Point click event.
     * @event pointClick
     * @memberof ChartBase
     */
				config.onclick = this._emitChartEvent.bind(this, 'pointClick');
				/**
     * Point mouse out event.
     * @event pointMouseout
     * @memberof ChartBase
     */
				config.onout = this._emitChartEvent.bind(this, 'pointMouseout');
				/**
     * Point mouse over event.
     * @event pointMouseoever
     * @memberof ChartBase
     */
				config.onover = this._emitChartEvent.bind(this, 'pointMouseover');
				/**
     * Data selected event.
     * @event dataSelected
     * @memberof ChartBase
     */
				config.onselected = this._emitChartEvent.bind(this, 'dataSelected');
				/**
     * Data unselected event.
     * @event dataUnselected
     * @memberof ChartBase
     */
				config.onunselected = this._emitChartEvent.bind(this, 'dataUnselected');
			}

			return config;
		},

		/**
   * Constructs color tiles for passed to billboard.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructTilesConfig: function _constructTilesConfig() {
			var _getStateObj2 = this._getStateObj(),
			    color = _getStateObj2.color;

			if (color.tiles) {
				var tiles = this._getTiles();

				color.tiles = function () {
					return tiles;
				};
				color.pattern = DEFAULT_COLORS;
			}

			return color;
		},

		/**
   * Constructs `zoom` billboard config property.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_constructZoomConfig: function _constructZoomConfig() {
			var state = this._getStateObj();
			var zoom = state.zoom;
			var config = zoom || {};

			/**
    * Zoom event.
    * @event zoom
    * @memberof ChartBase
    */
			config.onzoom = this._emitChartEvent.bind(this, 'zoom');
			/**
    * Zoom end event.
    * @event zoomEnd
    * @memberof ChartBase
    */
			config.onzoomend = this._emitChartEvent.bind(this, 'zoomEnd');
			/**
    * Zoom start event.
    * @event zoomStart
    * @memberof ChartBase
    */
			config.onzoomstart = this._emitChartEvent.bind(this, 'zoomStart');

			return config;
		},

		/**
   * Converts `data` state into consumable array for billboard.js
   * @memberof ChartBase
   * @param {Array} data
   * @protected
   * @return {Array}
   */
		_createDataArray: function _createDataArray(data) {
			return data.map(function (_ref) {
				var data = _ref.data,
				    id = _ref.id;

				return [id].concat(data);
			});
		},

		/**
   * Emits event based on arguments array.
   * @memberof ChartBase
   * @protected
   */
		_emitChartEvent: function _emitChartEvent() {
			this.emit.apply(this, arguments); // eslint-disable-line
		},

		/**
   * Gets all columns
   * @memberof ChartBase
   * @protected
   * @return {?Object}
   */
		_getColumns: function _getColumns() {
			return this.data;
		},

		/**
   * Gets column by column id.
   * @memberof ChartBase
   * @param {string} id column id
   * @protected
   * @return {?Object}
   */
		_getData: function _getData(id) {
			return this.data.find(function (data) {
				return data.id === id;
			});
		},

		/**
   * Retrieves state object, used to allow JSX implementation.
   * @memberof ChartBase
   * @protected
   * @return {Object}
   */
		_getStateObj: function _getStateObj() {
			return this;
		},

		/**
   * Get all tiles of the DOM.
   * @memberof ChartBase
   * @protected
   * @return {?Elements}
   */
		_getTiles: function _getTiles() {
			return DEFAULT_TILES.filter(function (val) {
				return document.querySelector('#' + val);
			}).map(function (val) {
				return document.querySelector('#' + val);
			});
		},

		/**
   * Maps `data` state to chart via `bb.load` method.
   * @memberof ChartBase
   * @param {Object} event The change event.
   * @protected
   */
		_handleDataChanged: function _handleDataChanged(event) {
			this._updateData(event.newVal);
		},

		/**
   * Maps `groups` state to chart via `bb.groups` method.
   * @memberof ChartBase
   * @protected
   */
		_handleGroupsChanged: function _handleGroupsChanged(_ref2) {
			var newVal = _ref2.newVal;

			this.bbChart.groups(newVal);
		},

		/**
   * Handles `loading` state.
   * @memberof ChartBase
   * @protected
   */
		_handleLoadingChanged: function _handleLoadingChanged(_ref3) {
			var newVal = _ref3.newVal;

			var chart = this.element.querySelector('[ref="chart"]');
			var placeholder = this.element.querySelector('[ref="placeholder"]');

			if (!newVal) {
				chart.removeAttribute('hidden');
				placeholder.setAttribute('hidden', 'hidden');
			} else {
				chart.setAttribute('hidden', 'hidden');
				placeholder.removeAttribute('hidden');
			}
		},

		/**
   * Maps `regions` state to chart via `bb.regions` method.
   * @memberof ChartBase
   * @protected
   */
		_handleRegionsChanged: function _handleRegionsChanged(_ref4) {
			var newVal = _ref4.newVal;

			this.bbChart.regions(newVal);
		},

		/**
   * Maps `size` state to chart via `bb.resize` method.
   * @memberof ChartBase
   * @protected
   */
		_handleSizeChanged: function _handleSizeChanged(_ref5) {
			var newVal = _ref5.newVal;

			this.bbChart.resize(newVal);
		},

		/**
   * Maps `type` state to chart via `bb.transform` method.
   * @memberof ChartBase
   * @protected
   */
		_handleTypeChanged: function _handleTypeChanged(_ref6) {
			var newVal = _ref6.newVal;

			this.bbChart.transform(newVal);
		},

		/**
   * Maps `x` state to chart via `bb.x` method.
   * @memberof ChartBase
   * @protected
   */
		_handleXChanged: function _handleXChanged(_ref7) {
			var newVal = _ref7.newVal;

			var column = this._getData(newVal);

			this.bbChart.x(column.data);
		},

		/**
   * Maps xs value to data points.
   * @memberof ChartBase
   * @param {Object} xs
   * @protected
   * @return {Object}
   */
		_mapXSValues: function _mapXSValues(xs) {
			var _this2 = this;

			return Object.keys(xs).reduce(function (xsValues, key) {
				var value = xs[key];

				var xColumn = _this2._getData(value);

				xsValues[key] = xColumn.data;

				return xsValues;
			}, {});
		},

		/**
   * Determines which ids should be passed to the unload property.
   * @memberof ChartBase
   * @param {Array} newData
   * @param {Array} prevData
   * @return {Array}
   * @static
   */
		_resolveRemovedData: function _resolveRemovedData(newData, prevData) {
			var ids = newData.map(function (data) {
				return data[0];
			});

			return prevData.reduce(function (removedIds, data) {
				var id = data[0];

				if (ids.indexOf(id) === -1) {
					removedIds.push(id);
				}

				return removedIds;
			}, []);
		},

		/**
   * Set's the chart's data
   * @memberof ChartBase
   * @param {?Object} columns The data to use.
   * @protected
   */
		_setColumns: function _setColumns(columns) {
			this.data = columns;
		},

		/**
   * Sets up the polling interval.
   * @memberof ChartBase
   * @protected
   */
		_setupPolling: function _setupPolling() {
			var _this3 = this;

			var config = this.getInitialConfig();
			var data = config.data;
			var pollingInterval = config.pollingInterval;

			if (pollingInterval) {
				if (this._pollingInterval) {
					clearInterval(this._pollingInterval);
				}

				this._pollingInterval = setInterval(function () {
					_this3._updateData(data);
				}, pollingInterval);
			}
		},

		/**
   * Updates the chart's data.
   * @memberof ChartBase
   * @param {Object} data The new data to load
   * @protected
   */
		_updateData: function _updateData(data) {
			var _this4 = this;

			resolveData(data).then(function (val) {
				var prevVal = _this4._createDataArray(_this4._resolvedData);

				_this4._resolvedData = val;

				var data = _this4._constructDataConfig(false);
				var newVal = data.columns;
				var removedIds = _this4._resolveRemovedData(newVal, prevVal);

				if (removedIds.length) {
					data.unload = removedIds;
				}

				_this4.bbChart.load(data);

				if (data.xs) {
					_this4.bbChart.xs(_this4._mapXSValues(data.xs));
				}

				_this4.emit('dataResolved', data);
			});
		}
	};

	/**
  * State definition.
  * @static
  * @type {!Object}
  */
	ChartBase.STATE = {
		/**
   * Sets the `loading` state.
   */
		_loading: _metalState.Config.bool().internal().value(true),

		/**
   * Data that will be rendered to the chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		area: _metalState.Config.shapeOf({
			above: _metalState.Config.bool().value(false),
			zerobased: _metalState.Config.bool().value(true)
		}),

		/**
   * Switches the x and y axis.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		axisRotated: _metalState.Config.bool(),

		/**
   * Styling and behavior of x axis.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		axisX: _metalState.Config.shapeOf({
			categories: _metalState.Config.array(),
			extent: _metalState.Config.array(),
			height: _metalState.Config.number(),
			label: _metalState.Config.object().string(),
			localtime: _metalState.Config.bool(),
			max: _metalState.Config.number(),
			min: _metalState.Config.number(),
			padding: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.object()]),
			show: _metalState.Config.bool(),
			tick: _metalState.Config.shapeOf({
				centered: _metalState.Config.bool(),
				count: _metalState.Config.number(),
				culling: _metalState.Config.bool().shapeOf({
					max: _metalState.Config.number()
				}),
				fit: _metalState.Config.bool(),
				format: _metalState.Config.oneOfType([_metalState.Config.func(), _metalState.Config.string()]),
				multiline: _metalState.Config.bool(),
				outer: _metalState.Config.bool(),
				rotate: _metalState.Config.number(),
				values: _metalState.Config.array(),
				width: _metalState.Config.number()
			}),
			type: _metalState.Config.oneOf(['category', 'indexed', 'timeseries'])
		}),

		/**
   * Styling and behavior of y2 axis.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		axisY2: _metalState.Config.shapeOf({
			center: _metalState.Config.number(),
			default: _metalState.Config.array(),
			inner: _metalState.Config.bool(),
			inverted: _metalState.Config.bool(),
			label: _metalState.Config.object().string(),
			max: _metalState.Config.number(),
			min: _metalState.Config.number(),
			padding: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.object()]),
			show: _metalState.Config.bool(),
			tick: _metalState.Config.shapeOf({
				count: _metalState.Config.number(),
				format: _metalState.Config.func(),
				outer: _metalState.Config.bool(),
				values: _metalState.Config.array()
			})
		}),

		/**
   * Styling and behavior of y axis.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		axisY: _metalState.Config.shapeOf({
			center: _metalState.Config.number(),
			default: _metalState.Config.array(),
			format: _metalState.Config.func(),
			inner: _metalState.Config.bool(),
			inverted: _metalState.Config.bool(),
			label: _metalState.Config.object().string(),
			max: _metalState.Config.number(),
			min: _metalState.Config.number(),
			padding: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.object()]),
			show: _metalState.Config.bool(),
			tick: _metalState.Config.shapeOf({
				count: _metalState.Config.number(),
				outer: _metalState.Config.bool(),
				values: _metalState.Config.array()
			}),
			type: _metalState.Config.oneOf(['category', 'indexed', 'timeseries'])
		}),

		/**
   * Styling and behavior of bars.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		bar: _metalState.Config.shapeOf({
			width: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.shapeOf({
				max: _metalState.Config.number(),
				ratio: _metalState.Config.number()
			})]),
			padding: _metalState.Config.number(),
			zerobased: _metalState.Config.bool()
		}),

		/** Styling and behavior of bubbles.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		bubble: _metalState.Config.shapeOf({
			maxR: _metalState.Config.number()
		}),

		/**
   * Defines a custom color pattern for chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		color: _metalState.Config.shapeOf({
			pattern: _metalState.Config.array().value(DEFAULT_COLORS),
			threshhold: _metalState.Config.shapeOf({
				unit: _metalState.Config.string(),
				value: _metalState.Config.array(),
				max: _metalState.Config.number()
			}),
			tiles: _metalState.Config.oneOfType([_metalState.Config.bool().value(false), _metalState.Config.func()])
		}).value({
			pattern: DEFAULT_COLORS,
			tiles: false
		}),

		/**
   * Defines a custom colors for data in chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		colors: _metalState.Config.object().value({}),

		/**
   * Sets billboard's data.color config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Function|undefined)}
   */
		colorFormatter: _metalState.Config.func(),

		/**
   * Data that will be rendered to the chart.
   * @default undefined
   * @deprecated since 2.0.0-rc.2
   * @instance
   * @memberof ChartBase
   * @type {?(Array|undefined)}
   */
		columns: {
			setter: '_setColumns',
			valueFn: '_getColumns'
		},

		/**
   * Data that will be rendered to the chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Array|undefined)}
   */
		data: _metalState.Config.oneOfType([_metalState.Config.arrayOf(_metalState.Config.shapeOf({
			axis: _metalState.Config.oneOf(['y', 'y2']),
			class: _metalState.Config.string(),
			color: _metalState.Config.string(),
			data: _metalState.Config.array().required(),
			hide: _metalState.Config.bool(),
			id: _metalState.Config.required().string(),
			name: _metalState.Config.string(),
			regions: _metalState.Config.array(),
			type: _metalState.Config.oneOf(_types2.default.all),
			x: _metalState.Config.string()
		})), _metalState.Config.object(), _metalState.Config.func(), _metalState.Config.string()]),

		/**
   * Configuration options for donut chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		donut: _metalState.Config.shapeOf({
			label: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				format: _metalState.Config.func(),
				threshhold: _metalState.Config.number(),
				ratio: _metalState.Config.func().number()
			}),
			expand: _metalState.Config.bool(),
			width: _metalState.Config.number(),
			title: _metalState.Config.string(),
			padAngle: _metalState.Config.number()
		}),

		/**
   * Sets label for when no data is loaded.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		emptyLabelText: _metalState.Config.string().setter(function (value) {
			return value ? { empty: { label: { text: value } } } : value;
		}),

		/**
   * Configuration options for guage chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		gauge: _metalState.Config.shapeOf({
			fullCircle: _metalState.Config.bool(),
			lable: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				format: _metalState.Config.func()
			}),
			expand: _metalState.Config.bool(),
			min: _metalState.Config.number(),
			max: _metalState.Config.number(),
			startingAngle: _metalState.Config.number(),
			units: _metalState.Config.string(),
			width: _metalState.Config.number()
		}),

		/**
   * Configuration options for grid chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		grid: _metalState.Config.shapeOf({
			// Cross reference this with source code, have a feeling this info is wrong
			focus: _metalState.Config.shapeOf({
				show: _metalState.Config.bool()
			}),
			lines: _metalState.Config.shapeOf({
				front: _metalState.Config.bool()
			}),
			x: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				lines: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
					class: _metalState.Config.string(),
					position: _metalState.Config.oneOf(['start', 'middle', 'end']),
					text: _metalState.Config.string(),
					value: _metalState.Config.any()
				}))
			}),
			y: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				lines: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
					class: _metalState.Config.string(),
					position: _metalState.Config.oneOf(['start', 'middle', 'end']),
					text: _metalState.Config.string(),
					value: _metalState.Config.any()
				}))
			}),
			ticks: _metalState.Config.number()
		}).value(DEFAULT_GRID_OBJECT),

		/**
   * Sets billboard's data.groups config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Array|undefined)}
   */
		groups: _metalState.Config.array(),

		/**
   * If set to true hides all data.
   * @default false
   * @instance
   * @memberof ChartBase
   * @type {?(boolean|undefined)}
   */
		hide: _metalState.Config.bool().value(false),

		/**
   * Id to be applied to the element.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		id: _metalState.Config.string(),

		/**
   * Intersection display options.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		intersection: _metalState.Config.shapeOf({
			enabled: _metalState.Config.bool(),
			brighten: _metalState.Config.bool(),
			inputType: _metalState.Config.shapeOf({
				mouse: _metalState.Config.bool(),
				touch: _metalState.Config.bool()
			})
		}),

		/**
   * Sets billboard's data.json config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Array|boolean|undefined)}
   */
		json: _metalState.Config.array(),

		/**
   * Sets billboard's data.keys config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Array|undefined)}
   */
		keys: _metalState.Config.array().setter(function (value) {
			return value ? { value: value } : value;
		}),

		/**
   * Sets billboard's data.labels config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Boolean|Function|undefined)}
   */
		labels: _metalState.Config.bool().func().setter(function (value) {
			if (!value) {
				return value;
			} else if (typeof value === 'boolean') {
				return {
					labels: value
				};
			} else {
				return {
					labels: {
						format: value
					}
				};
			}
		}),

		/**
   * Legend display options.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		legend: _metalState.Config.shapeOf({
			contents: _metalState.Config.shapeOf({
				bindto: _metalState.Config.any(),
				template: _metalState.Config.oneOfType([_metalState.Config.func(), _metalState.Config.string()])
			}),
			hide: _metalState.Config.bool(),
			position: _metalState.Config.oneOf(['bottom', 'inset', 'right']),
			inset: _metalState.Config.shapeOf({
				anchor: _metalState.Config.oneOf(['bottom-left', 'bottom-right', 'top-left', 'top-right']),
				step: _metalState.Config.number(),
				x: _metalState.Config.number(),
				y: _metalState.Config.number()
			}),
			show: _metalState.Config.bool()
		}),

		/**
   * Display settings for chart lines.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		line: _metalState.Config.shapeOf({
			classes: _metalState.Config.array(),
			connectNull: _metalState.Config.bool(),
			step: _metalState.Config.shapeOf({
				type: _metalState.Config.oneOf(['step', 'step-after', 'step-before'])
			})
		}).value({
			classes: DEFAULT_LINE_CLASSES
		}),

		/**
   * Sets billboard's data.mimeType config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		mimeType: _metalState.Config.string(),

		/**
   * Sets billboard's data.order config.
   * @default desc
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		order: _metalState.Config.string().value('desc'),

		/**
   * Sets padding on chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		padding: _metalState.Config.shapeOf({
			bottom: _metalState.Config.number(),
			left: _metalState.Config.number(),
			right: _metalState.Config.number(),
			top: _metalState.Config.number()
		}),

		/**
   * Configuration options for pie chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		pie: _metalState.Config.shapeOf({
			label: _metalState.Config.shapeOf({
				show: _metalState.Config.bool(),
				format: _metalState.Config.func(),
				threshhold: _metalState.Config.number(),
				ratio: _metalState.Config.func().number()
			}),
			expand: _metalState.Config.bool(),
			padAngle: _metalState.Config.number()
		}),

		/**
   * Configuration options for chart points.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		point: _metalState.Config.shapeOf({
			show: _metalState.Config.bool(),
			r: _metalState.Config.number(),
			focus: _metalState.Config.shapeOf({
				expand: _metalState.Config.shapeOf({
					enabled: _metalState.Config.bool(),
					r: _metalState.Config.number()
				}),
				select: _metalState.Config.shapeOf({
					r: _metalState.Config.number()
				})
			}),
			pattern: _metalState.Config.array()
		}).value({
			pattern: DEFAULT_POINT_PATTERNS
		}),

		/**
   * Set an interval (in ms) to fetch the data.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?Number}
   */
		pollingInterval: _metalState.Config.number(),

		/**
   * Creates custom regions on chart that can be styled.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		regions: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
			class: _metalState.Config.string(),
			enabled: _metalState.Config.oneOf(['x', 'y']).required(),
			end: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.string()]).required(),
			start: _metalState.Config.oneOfType([_metalState.Config.number(), _metalState.Config.string()]).required()
		})),

		/**
   * Determines if chart auto resizes when viewport size changes.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(boolean|undefined)}
   */
		resizeAuto: _metalState.Config.bool().setter(function (value) {
			return value ? { auto: value } : value;
		}),

		/**
   * Load data from a multidimensional array. Sets billboard's `data.rows`
   * config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(array|undefined)}
   */
		rows: _metalState.Config.array(),

		/**
   * Sets billboard's `data.selection` config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		selection: _metalState.Config.shapeOf({
			draggable: _metalState.Config.bool(),
			enabled: _metalState.Config.bool(),
			grouped: _metalState.Config.bool(),
			isselectable: _metalState.Config.func(),
			multiple: _metalState.Config.bool()
		}),

		/**
   * Sets size of chart.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		size: _metalState.Config.shapeOf({
			height: _metalState.Config.number(),
			width: _metalState.Config.number()
		}),

		/**
   * Determines interpolation type of spline charts.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|object|undefined)}
   */
		splineInterpolationType: _metalState.Config.oneOfType([_metalState.Config.object(), _metalState.Config.string()]).setter(function (value) {
			return value ? { interpolation: { type: value } } : value;
		}),

		/**
   * Config options for subcharts.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		subchart: _metalState.Config.shapeOf({
			show: _metalState.Config.bool(),
			size: _metalState.Config.shapeOf({
				height: _metalState.Config.number()
			}),
			onbrush: _metalState.Config.func()
		}),

		/**
   * Customizes classname for svg element.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		svgClassname: _metalState.Config.string().setter(function (value) {
			return value ? { classname: value } : value;
		}),

		/**
   * Display options for title element.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		title: _metalState.Config.shapeOf({
			text: _metalState.Config.string(),
			padding: _metalState.Config.shapeOf({
				bottom: _metalState.Config.number(),
				left: _metalState.Config.number(),
				right: _metalState.Config.number(),
				top: _metalState.Config.number()
			}),
			position: _metalState.Config.string()
		}),

		/**
   * Display options for tooltip.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		tooltip: _metalState.Config.shapeOf({
			show: _metalState.Config.bool(),
			grouped: _metalState.Config.bool(),
			format: _metalState.Config.shapeOf({
				name: _metalState.Config.func(),
				title: _metalState.Config.func(),
				value: _metalState.Config.func()
			}),
			contents: _metalState.Config.func()
		}),

		/**
   * Sets duration of transitions.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(number|undefined)}
   */
		transitionDuration: _metalState.Config.number().setter(function (value) {
			return value ? { duration: value } : value;
		}),

		/**
   * The variety of chart that will be rendered.
   * @default line
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		type: _metalState.Config.oneOf(_types2.default.all).value('line'),

		/**
   * Load a CSV or JSON file from a URL.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		url: _metalState.Config.string(),

		/**
   * Sets billboard's data.x config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		x: _metalState.Config.string(),

		/**
   * Sets billboard's data.xs config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(object|undefined)}
   */
		xs: _metalState.Config.object(),

		/**
   * Sets billboard's data.xFormat config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(string|undefined)}
   */
		xFormat: _metalState.Config.string(),

		/**
   * Sets billboard's data.xLocaltime config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(boolean|undefined)}
   */
		xLocaltime: _metalState.Config.bool(),

		/**
   * Sets billboard's data.xSort config.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		xSort: _metalState.Config.bool(),

		/**
   * Configuration for bb chart zoom capabilities.
   * @default undefined
   * @instance
   * @memberof ChartBase
   * @type {?(Object|undefined)}
   */
		zoom: _metalState.Config.shapeOf({
			enabled: _metalState.Config.bool().value(true),
			rescale: _metalState.Config.bool().value(false),
			extent: _metalState.Config.array()
		})
	};

	exports.bb = _billboard.bb;
	exports.d3 = d3;
	exports.ChartBase = ChartBase;
	exports.default = ChartBase;
	//# sourceMappingURL=ChartBase.js.map
});
//# sourceMappingURL=ChartBase.js.map