'use strict';

Liferay.Loader.define("frontend-taglib-chart$clay-charts-shared@2.15.1/lib/geomap", ['module', 'exports', 'require', 'frontend-taglib-chart$d3', 'frontend-js-metal-web$metal', './data'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Geomap = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _d = require("frontend-taglib-chart$d3");

	var d3 = _interopRequireWildcard(_d);

	var _metal = require("frontend-js-metal-web$metal");

	var _data = require('./data');

	function _interopRequireWildcard(obj) {
		if (obj && obj.__esModule) {
			return obj;
		} else {
			var newObj = {};if (obj != null) {
				for (var key in obj) {
					if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
				}
			}newObj.default = obj;return newObj;
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var DEFAULT_COLOR = {
		range: {
			min: '#b1d4ff',
			max: '#0065e4'
		},
		selected: '#4b9bff',
		value: 'pop_est'
	};

	/**
  * Geomap Base class.
  * @class Geomap
  */

	var Geomap = exports.Geomap = function () {
		/**
   * @inheritDoc
   */
		function Geomap(config) {
			_classCallCheck(this, Geomap);

			this._data = config.data;
			this._element = config.element;
			this._color = config.color || DEFAULT_COLOR;
			this._id = config.id;
			this._pollingInterval = config.pollingInterval;

			this._height = '100%';
			this._width = '100%';
		}

		/**
   * Function to call when component is first mounting/attaching
   */

		_createClass(Geomap, [{
			key: 'attached',
			value: function attached() {
				var _this = this;

				if ((0, _metal.isServerSide)()) {
					return;
				}

				var w = typeof this._width === 'string' ? this._width : this._width + 'px';
				var h = typeof this._height === 'string' ? this._height : this._height + 'px';

				this.svg = d3.select(this._element).append('svg').attr('width', w).attr('height', h);

				this._handleClickHandler = this._handleClick.bind(this);

				this.rect = this.svg.append('rect').attr('fill', 'rgba(1, 1, 1, 0)').attr('width', w).attr('height', h).on('click', this._handleClickHandler);

				var bounds = this.svg.node().getBoundingClientRect();

				this.svgGroup = this.svg.append('g');
				this.mapLayer = this.svgGroup.append('g');
				this.projection = d3.geoMercator().scale(100).translate([bounds.width / 2, bounds.height / 2]);

				this.path = d3.geoPath().projection(this.projection);
				this._selected = null;

				this._onDataLoadHandler = this._onDataLoad.bind(this);

				(0, _data.resolveData)(this._data).then(function (val) {
					_this._onDataLoadHandler.apply(_this, [null, val]);

					if (_this._internalPollingInterval) {
						clearInterval(_this._internalPollingInterval);
					}

					if (_this.pollingInterval) {
						_this._internalPollingInterval = setInterval(function () {
							_this._updateData(_this.data);
						}, _this._pollingInterval);
					}
				}).catch(function (err) {
					_this._onDataLoadHandler.apply(_this, [err, null]);
				});
			}

			/**
    * Function to call when disposing instance
    */

		}, {
			key: 'disposed',
			value: function disposed() {
				if ((0, _metal.isServerSide)()) {
					return;
				}

				if (this._internalPollingInterval) {
					clearInterval(this._internalPollingInterval);
					this._internalPollingInterval = null;
				}

				if (this.svg) {
					this.svg.remove();
				}
			}

			/**
    * Fill function
    * @param {Object} d
    * @protected
    * @return {Number}
    */

		}, {
			key: '_fillFn',
			value: function _fillFn(d) {
				var value = d && d.properties ? d.properties[this._color.value] : 0;
				return this.colorScale(value);
			}
			/**
    * @inheritDoc
    */

		}, {
			key: 'getSize',
			value: function getSize() {
				return {
					height: this._height,
					width: this._width
				};
			}

			/**
    * Click handler
    * @param {Object} d
    * @protected
    */

		}, {
			key: '_handleClick',
			value: function _handleClick(d) {
				var _this2 = this;

				if (d && this._selected !== d) {
					this._selected = d;
				} else {
					this._selected = null;
				}

				// Highlight the clicked province
				this.mapLayer.selectAll('path').style('fill', function (d) {
					return _this2._selected && d === _this2._selected ? _this2._color.selected : _this2._fillFn.bind(_this2)(d);
				});
			}

			/**
    * Mouse over handler
    * @param {Object} feature
    * @param {Number} idx
    * @param {Array} selection
    * @protected
    */

		}, {
			key: '_handleMouseOver',
			value: function _handleMouseOver(feature, idx, selection) {
				var node = selection[idx];
				d3.select(node).style('fill', this._color.selected);
			}

			/**
    * Mouse over handler
    * @param {Object} feature
    * @param {Number} idx
    * @param {Array} selection
    * @protected
    */

		}, {
			key: '_handleMouseOut',
			value: function _handleMouseOut(feature, idx, selection) {
				var node = selection[idx];
				d3.select(node).style('fill', this._fillFn.bind(this));
			}

			/**
    * Data load handler
    * @param {Error} err
    * @param {Object} mapData
    * @protected
    */

		}, {
			key: '_onDataLoad',
			value: function _onDataLoad(err, mapData) {
				var _this3 = this;

				if (err) {
					throw err;
				}
				var features = mapData.features;

				// Calculate domain based on values received
				var values = features.map(function (f) {
					return f.properties[_this3._color.value];
				});

				this._domainMin = Math.min.apply(null, values);
				this._domainMax = Math.max.apply(null, values);

				this.colorScale = d3.scaleLinear().domain([this._domainMin, this._domainMax]).range([this._color.range.min, this._color.range.max]);

				this.mapLayer.selectAll('path').data(features).enter().append('path').attr('d', this.path).attr('vector-effect', 'non-scaling-stroke').attr('fill', this._fillFn.bind(this)).on('click', this._handleClickHandler).on('mouseout', this._handleMouseOut.bind(this)).on('mouseover', this._handleMouseOver.bind(this));
			}

			/**
    * @inheritDoc
    * @param {Object} data The updated data
    * @protected
    */

		}, {
			key: '_updateData',
			value: function _updateData(data) {
				var _this4 = this;

				(0, _data.resolveData)(data).then(function (val) {
					_this4._onDataLoadHandler.apply(_this4, [null, val]);
				}).catch(function (err) {
					_this4._onDataLoadHandler.apply(_this4, [err, null]);
				});
			}
		}]);

		return Geomap;
	}();
	//# sourceMappingURL=geomap.js.map
});
//# sourceMappingURL=geomap.js.map