'use strict';

Liferay.Loader.define('frontend-taglib-chart$clay-charts-shared@2.15.1/lib/data', ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.resolveData = resolveData;

	var _metal = require('frontend-js-metal-web$metal');

	/**
  * @param {Array|Function|Object} data
  * @return {Promise}
  */
	function resolveData(data) {
		return new Promise(function (resolve, reject) {
			if (Array.isArray(data) || (0, _metal.isObject)(data) && !(0, _metal.isFunction)(data)) {
				resolve(data);
			} else if ((0, _metal.isFunction)(data)) {
				data().then(function (val) {
					return resolve(val);
				});
			} else if ((0, _metal.isString)(data)) {
				fetch(data, { cors: 'cors' }).then(function (res) {
					return res.json();
				}).then(function (res) {
					if (!(0, _metal.isDefAndNotNull)(res)) {
						return reject(res);
					}
					if ((0, _metal.isDefAndNotNull)(res.data)) {
						return resolve(res.data);
					} else {
						return resolve(res);
					}
				});
			} else {
				reject('Could not resolve data: ' + data);
			}
		});
	}
	//# sourceMappingURL=data.js.map
});
//# sourceMappingURL=data.js.map