"use strict";

Liferay.Loader.define("flags-taglib@4.0.11/flags/Flags.es", ['module', 'exports', 'require', 'frontend-js-web/liferay/compat/modal/Modal.es', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', './Flags.soy', 'frontend-js-metal-web$metal-state', 'frontend-taglib-clay$clay-button'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _Flags = _interopRequireDefault(require("./Flags.soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _clayButton = _interopRequireDefault(require("frontend-taglib-clay$clay-button"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * It opens a dialog where the user can flag the page.
   * @abstract
   * @extends {PortletBase}
   */
  var Flags =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(Flags, _PortletBase);

    function Flags() {
      _classCallCheck(this, Flags);

      return _possibleConstructorReturn(this, _getPrototypeOf(Flags).apply(this, arguments));
    }

    _createClass(Flags, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this.namespace = this.portletNamespace;
      }
      /**
       * Gets the reason selected by the user.
       * @return {String} reason
       */

    }, {
      key: "_getReason",
      value: function _getReason() {
        var reason;

        if (this.refs.modal.refs.otherReason) {
          reason = this.refs.modal.refs.otherReason.value || Liferay.Language.get('no-reason-specified');
        } else {
          reason = this.refs.modal.refs.reason.value;
        }

        return reason;
      }
      /**
       * Closes the dialog to flag the page.
       */

    }, {
      key: "_handleCloseDialogClick",
      value: function _handleCloseDialogClick() {
        this._reportDialogOpen = false;
        this._showConfirmationMessage = false;
        this._showErrorMessage = false;
      }
      /**
       * Opens a dialog where the user can flag the page.
       */

    }, {
      key: "_handleFlagButtonClick",
      value: function _handleFlagButtonClick() {
        this._reportDialogOpen = true;
      }
      /**
       * Checks the reason selected by the user, and allows
       * to introduce a specific reasons if necessary.
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_handleReasonChange",
      value: function _handleReasonChange(event) {
        this._selectedReason = event.delegateTarget.value;
      }
      /**
       * Forms the submit.
       * @internal
       * @protected
       */

    }, {
      key: "_handleReportButtonClick",
      value: function _handleReportButtonClick() {
        this._sendReport();
      }
      /**
       * Makes an ajax request to submit the data.
       * @param {Event} event
       * @protected
       */

    }, {
      key: "_sendReport",
      value: function _sendReport() {
        var _this = this;

        this.formData[this.ns('reason')] = this._getReason();
        this.formData[this.ns('reporterEmailAddress')] = this.refs.modal.refs.reporterEmailAddress.value;
        var formData = new FormData();

        for (var name in this.formData) {
          formData.append(name, this.formData[name]);
        }

        fetch(this.uri, {
          body: formData,
          credentials: 'include',
          method: 'post'
        }).then(function (xhr) {
          if (xhr.status === Liferay.STATUS_CODE.OK) {
            _this._showConfirmationMessage = true;
          }
        }).catch(function () {
          _this._showErrorMessage = true;
        });
      }
    }]);

    return Flags;
  }(_PortletBase2.default);
  /**
   * State definition.
   * @ignore
   * @static
   * @type {!Object}
   */

  Flags.STATE = {
    /**
     * Flag to indicate if dialog should be open.
     * @default false
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    _reportDialogOpen: _metalState.Config.bool().internal().value(false),

    /**
     * Flag to indicate if dialog should show the confirmation message.
     * @default false
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    _showConfirmationMessage: _metalState.Config.bool().internal().value(false),

    /**
     * Flag to indicate if dialog should show the error message.
     * @default false
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    _showErrorMessage: _metalState.Config.bool().internal().value(false),

    /**
     * Selected reason to flag.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    _selectedReason: _metalState.Config.string().internal(),

    /**
     * Company name.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    companyName: _metalState.Config.string().required(),

    /**
     * CSS classes to be applied to the element.
     * @instance
     * @memberof Flags
     * @type {?string}
     * @default undefined
     */
    elementClasses: _metalState.Config.string(),

    /**
     * Whether the form to flag is enabled or not.
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    enabled: _metalState.Config.bool().required(),

    /**
     * Whether the user is able to flag the page.
     * @instance
     * @memberof Flags
     * @type {!Boolean}
     */
    flagsEnabled: _metalState.Config.bool().required(),

    /**
     * Portlet's data needed to send within the form.
     * @instance
     * @memberof Flags
     * @type {!Object}
     */
    formData: _metalState.Config.object().required(),

    /**
     * Component id.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    id: _metalState.Config.string().required(),

    /**
     * Whether to show message text as a label next
     * to the flag icon or as a tooltip.
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    label: _metalState.Config.bool().required(),

    /**
     * Text to display next to the flag icon or in the tooltip.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    message: _metalState.Config.string(),

    /**
     * Path to Terms of Use.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    pathTermsOfUse: _metalState.Config.string().required(),

    /**
     * Path to images.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Portlet's namespace
     * @instance
     * @memberof Flags
     * @type {String}
     */
    portletNamespace: _metalState.Config.string().required(),

    /**
     * Map (original language key and translated language key)
     * of possible reasons to flag a content.
     * @instance
     * @memberof Flags
     * @type {Object}
     */
    reasons: _metalState.Config.object().required(),

    /**
     * Email of the user who reports
     * the flag.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    reporterEmailAddress: _metalState.Config.string(),

    /**
     * Wheter the user is signed in or not.
     * @instance
     * @memberof Flags
     * @type {Boolean}
     */
    signedIn: _metalState.Config.bool().required(),

    /**
     * Uri to send the report fetch request.
     * @instance
     * @memberof Flags
     * @type {String}
     */
    uri: _metalState.Config.string().required()
  }; // Register component

  _metalSoy.default.register(Flags, _Flags.default);

  var _default = Flags;
  exports.default = _default;
  //# sourceMappingURL=Flags.es.js.map
});
//# sourceMappingURL=Flags.es.js.map