"use strict";

Liferay.Loader.define("frontend-taglib@4.0.15/contextual_sidebar/ContextualSidebar.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ContextualSidebar.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.ContextualSidebar = void 0;

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metal = require("frontend-js-metal-web$metal");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _ContextualSidebar = _interopRequireDefault(require("./ContextualSidebar.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * ContextualSidebar
   * @review
   */
  var ContextualSidebar =
  /*#__PURE__*/
  function (_Component) {
    _inherits(ContextualSidebar, _Component);

    function ContextualSidebar() {
      _classCallCheck(this, ContextualSidebar);

      return _possibleConstructorReturn(this, _getPrototypeOf(ContextualSidebar).apply(this, arguments));
    }

    _createClass(ContextualSidebar, [{
      key: "created",

      /**
       * @inheritDoc
       * @review
       */
      value: function created() {
        document.body.classList.add('has-contextual-sidebar');
        this._productMenuToggle = $('.product-menu-toggle');
        this._productMenu = $(this._productMenuToggle.data('target'));
        this._handleOpenProductMenu = this._handleOpenProductMenu.bind(this);

        this._productMenu.on('openStart.lexicon.sidenav', this._handleOpenProductMenu);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        document.body.classList.remove('has-contextual-sidebar');

        this._productMenu.off('openStart.lexicon.sidenav', this._handleOpenProductMenu);
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "prepareStateForRender",
      value: function prepareStateForRender(state) {
        return Object.assign({}, state, {
          body: _metalSoy.default.toIncDom(this.body || ''),
          header: _metalSoy.default.toIncDom(this.header || '')
        });
      }
      /**
       * Disallow setting element display to none
       * @inheritDoc
       * @review
       */

    }, {
      key: "syncVisible",
      value: function syncVisible() {}
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this.visible) {
          document.body.classList.add('contextual-sidebar-visible');

          this._productMenuToggle.sideNavigation('hide');
        } else {
          document.body.classList.remove('contextual-sidebar-visible');
        }
      }
      /**
       * Handle product menu's show event and emits a hide event.
       * Components using ContextualSidebar should change it's visible
       * property at this point.
       * @private
       * @review
       */

    }, {
      key: "_handleOpenProductMenu",
      value: function _handleOpenProductMenu() {
        this.emit('hide');
      }
    }]);

    return ContextualSidebar;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.ContextualSidebar = ContextualSidebar;
  ContextualSidebar.STATE = {
    /**
     * Sidebar body content
     * @default undefined
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {!string}
     */
    body: _metalState.Config.any().setter(function (body) {
      return (0, _metal.isObject)(body) && !(0, _metal.isFunction)(body) ? body.value.content : body;
    }).required(),

    /**
     * Optional CSS classes added to the sidebar body wrapper
     * @default ''
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {string}
     */
    bodyClasses: _metalState.Config.string().value(''),

    /**
     * Optional CSS classes added to the sidebar wrapper
     * @default ''
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {string}
     */
    elementClasses: _metalState.Config.string().value(''),

    /**
     * Sidebar header content
     * @default undefined
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {!string}
     */
    header: _metalState.Config.any().setter(function (header) {
      return (0, _metal.isObject)(header) && !(0, _metal.isFunction)(header) ? header.value.content : header;
    }).required(),

    /**
     * Optional CSS classes added to the sidebar header wrapper
     * @default ''
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {string}
     */
    headerClasses: _metalState.Config.string().value(''),

    /**
     * Autogenerated id provided by the template engine
     * @default ''
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {string}
     */
    id: _metalState.Config.string().value(''),

    /**
     * Allow opening/closing contextual sidebar
     * @default undefined
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {!boolean}
     */
    visible: _metalState.Config.bool().required(),

    /**
     * Internal property that keeps an existing ProductMenu sidebar synced.
     * @default undefined
     * @instance
     * @memberOf ContextualSidebar
     * @review
     * @type {object}
     */
    _productMenu: _metalState.Config.internal()
  };

  _metalSoy.default.register(ContextualSidebar, _ContextualSidebar.default);

  var _default = ContextualSidebar;
  exports.default = _default;
  //# sourceMappingURL=ContextualSidebar.es.js.map
});
//# sourceMappingURL=ContextualSidebar.es.js.map