"use strict";

Liferay.Loader.define("asset-taglib@4.0.15/asset_categories_selector/AssetVocabularyCategoriesSelector.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-multi-select', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './AssetVocabularyCategoriesSelector.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.AssetVocabularyCategoriesSelector = void 0;

  require("frontend-taglib-clay$clay-multi-select");

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _AssetVocabularyCategoriesSelector = _interopRequireDefault(require("./AssetVocabularyCategoriesSelector.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Wraps Clay's existing <code>MultiSelect</code> component that offers the user
   * a categories selection input.
   */
  var AssetVocabularyCategoriesSelector =
  /*#__PURE__*/
  function (_Component) {
    _inherits(AssetVocabularyCategoriesSelector, _Component);

    function AssetVocabularyCategoriesSelector() {
      _classCallCheck(this, AssetVocabularyCategoriesSelector);

      return _possibleConstructorReturn(this, _getPrototypeOf(AssetVocabularyCategoriesSelector).apply(this, arguments));
    }

    _createClass(AssetVocabularyCategoriesSelector, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        var _get2;

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        (_get2 = _get(_getPrototypeOf(AssetVocabularyCategoriesSelector.prototype), "attached", this)).call.apply(_get2, [this].concat(args));

        this._dataSource = this._handleQuery.bind(this);
      }
      /**
       * Opens the tag selection dialog.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleButtonClicked",
      value: function _handleButtonClicked(event) {
        AUI().use('liferay-item-selector-dialog', function (A) {
          var uri = A.Lang.sub(decodeURIComponent(this.portletURL), {
            selectedCategories: this.selectedItems.map(function (item) {
              return item.value;
            }).join(),
            singleSelect: this.singleSelect,
            vocabularyIds: this.vocabularyIds.concat()
          });
          var itemSelectorDialog = new A.LiferayItemSelectorDialog({
            eventName: this.eventName,
            on: {
              selectedItemChange: function (event) {
                var selectedItems = event.newVal;

                if (selectedItems) {
                  this.selectedItems = Object.keys(selectedItems).map(function (itemKey) {
                    return {
                      label: selectedItems[itemKey].value,
                      value: selectedItems[itemKey].categoryId
                    };
                  });
                }
              }.bind(this)
            },
            'strings.add': Liferay.Language.get('add'),
            title: Liferay.Language.get('select-categories'),
            url: uri
          });
          itemSelectorDialog.open();
        }.bind(this));
      }
    }, {
      key: "_handleInputFocus",
      value: function _handleInputFocus(event) {
        this.emit('inputFocus', event);
      }
      /**
       * Converts the list of selected categories into a comma-separated serialized
       * version to be used as a fallback for old services and implementations.
       *
       * @private
       * @return {string} The serialized, comma-separated version of the selected items.
       */

    }, {
      key: "_getCategoryIds",
      value: function _getCategoryIds() {
        return this.selectedItems.map(function (selectedItem) {
          return selectedItem.value;
        }).join();
      }
      /**
       * Shows the category error.
       *
       * @private
       */

    }, {
      key: "_handleErrorAddinglabelItem",
      value: function _handleErrorAddinglabelItem(event) {
        if (event.data.itemDoesNotExists) {
          this._typedCategory = event.target.inputValue;
          this._unexistingCategoryError = true;
        }
      }
      /**
       * Prevents auto cleaning.
       *
       * @private
       */

    }, {
      key: "_handleInputOnBlur",
      value: function _handleInputOnBlur(event) {
        event.preventDefault();
        var filteredItems = event.target.filteredItems;
        var inputValue = event.target.inputValue;

        if (inputValue) {
          if (!filteredItems || filteredItems && filteredItems.length === 0) {
            this._typedCategory = inputValue;
            this._unexistingCategoryError = true;
          }

          if (filteredItems && filteredItems.length > 0 && filteredItems[0].data.label === inputValue) {
            var existingCategory = this.selectedItems.find(function (category) {
              return category.label === inputValue;
            });

            if (!existingCategory) {
              var item = {
                label: filteredItems[0].data.label,
                value: filteredItems[0].data.value
              };
              this.selectedItems = this.selectedItems.concat(item);
              event.target.inputValue = '';
            }
          }
        }
      }
      /**
       * Updates tags fallback and notifies that a new tag has been added.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleItemAdded",
      value: function _handleItemAdded(event) {
        this.selectedItems = event.data.selectedItems;
      }
      /**
       * Updates tags fallback and notifies that a new tag has been removed.
       *
       * @param {!Event} event The event.
       * @private
       */

    }, {
      key: "_handleItemRemoved",
      value: function _handleItemRemoved(event) {
        this.selectedItems = event.data.selectedItems;
      }
      /**
       * Sync the _intpuvalue and hide the category error
       *
       * @private
       * @review
       */

    }, {
      key: "_handleSyncInputValue",
      value: function _handleSyncInputValue(val) {
        this._inputValue = val.newVal;
        this._unexistingCategoryError = false;
      }
    }, {
      key: "syncSelectedItems",
      value: function syncSelectedItems(event) {
        this.categoryIds = this._getCategoryIds();
        this.emit('selectedItemsChange', {
          selectedItems: event,
          vocabularyId: this.vocabularyIds[0]
        });
      }
      /**
       * Responds to user input to retrieve the list of available tags from the
       * tags search service.
       *
       * @param {!string} query
       * @private
       */

    }, {
      key: "_handleQuery",
      value: function _handleQuery(query) {
        var _this = this;

        return new Promise(function (resolve, reject) {
          var serviceOptions = {
            end: 20,
            groupIds: _this.groupIds,
            name: "%".concat(query, "%"),
            start: 0,
            vocabularyIds: _this.vocabularyIds
          };
          serviceOptions['-obc'] = null;
          Liferay.Service('/assetcategory/search', serviceOptions, function (categories) {
            return resolve(categories.map(function (category) {
              return {
                label: category.titleCurrentValue,
                value: category.categoryId
              };
            }));
          });
        });
      }
    }]);

    return AssetVocabularyCategoriesSelector;
  }(_metalComponent.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.AssetVocabularyCategoriesSelector = AssetVocabularyCategoriesSelector;
  AssetVocabularyCategoriesSelector.STATE = {
    /**
     * <code>MultiSelect</code> component's input value.
     *
     * @default undefined
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @private
     * @type {?(string|undefined)}
     */
    _inputValue: _metalState.Config.string().internal(),

    /**
     * @default false
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @private
     * @type {?bool}
     */
    _unexistingCategoryError: _metalState.Config.bool().value(false),

    /**
     * Flag to indicate whether input can create an item.
     *
     * @default false
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @type {?bool}
     */
    allowInputCreateItem: _metalState.Config.bool().value(false),

    /**
     * A comma separated list of selected items.
     *
     * @default undefined
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @type {?string}
     */
    categoryIds: _metalState.Config.string().value(''),
    groupIds: _metalState.Config.array().value([]),

    /**
     * Event name which fires when the user selects a display page using the
     * item selector.
     *
     * @default undefined
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @type {?string}
     */
    eventName: _metalState.Config.string(),

    /**
     * URL of a portlet to display the tags.
     *
     * @default undefined
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @type {?string}
     */
    portletURL: _metalState.Config.string(),

    /**
     * List of selected items.
     *
     * @default undefined
     * @instance
     * @memberof AssetVocabularyCategoriesSelector
     * @type {?Array}
     */
    selectedItems: _metalState.Config.array().value([]),
    singleSelect: _metalState.Config.bool().value(false),
    vocabularyIds: _metalState.Config.array().value([])
  };

  _metalSoy.default.register(AssetVocabularyCategoriesSelector, _AssetVocabularyCategoriesSelector.default);

  var _default = AssetVocabularyCategoriesSelector;
  exports.default = _default;
  //# sourceMappingURL=AssetVocabularyCategoriesSelector.es.js.map
});
//# sourceMappingURL=AssetVocabularyCategoriesSelector.es.js.map