/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceAttributes;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class TestPropertySourceUtils {
    private static final Log logger = LogFactory.getLog(TestPropertySourceUtils.class);
    public static final String INLINED_PROPERTIES_PROPERTY_SOURCE_NAME = "Inlined Test Properties";

    private TestPropertySourceUtils() {
    }

    static MergedTestPropertySources buildMergedTestPropertySources(Class<?> testClass) {
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null) {
            return new MergedTestPropertySources();
        }
        List<TestPropertySourceAttributes> attributesList = TestPropertySourceUtils.resolveTestPropertySourceAttributes(testClass);
        String[] locations = TestPropertySourceUtils.mergeLocations(attributesList);
        String[] properties = TestPropertySourceUtils.mergeProperties(attributesList);
        return new MergedTestPropertySources(locations, properties);
    }

    private static List<TestPropertySourceAttributes> resolveTestPropertySourceAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<TestPropertySourceAttributes> attributesList = new ArrayList<TestPropertySourceAttributes>();
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        Assert.notNull(descriptor, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (descriptor != null) {
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @TestPropertySource attributes [%s] for declaring class [%s].", annAttrs, rootDeclaringClass.getName()));
            }
            TestPropertySourceAttributes attributes = new TestPropertySourceAttributes(rootDeclaringClass, annAttrs);
            if (logger.isTraceEnabled()) {
                logger.trace("Resolved TestPropertySource attributes: " + attributes);
            }
            attributesList.add(attributes);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType);
        }
        return attributesList;
    }

    private static String[] mergeLocations(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> locations = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing locations for TestPropertySource attributes %s", attrs));
            }
            String[] locationsArray = TestContextResourceUtils.convertToClasspathResourcePaths(attrs.getDeclaringClass(), attrs.getLocations());
            locations.addAll(0, Arrays.asList(locationsArray));
            if (attrs.isInheritLocations()) continue;
            break;
        }
        return StringUtils.toStringArray(locations);
    }

    private static String[] mergeProperties(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> properties = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing inlined properties for TestPropertySource attributes %s", attrs));
            }
            properties.addAll(0, Arrays.asList(attrs.getProperties()));
            if (attrs.isInheritProperties()) continue;
            break;
        }
        return StringUtils.toStringArray(properties);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableApplicationContext context, String[] locations) {
        Assert.notNull((Object)context, (String)"context must not be null");
        Assert.notNull((Object)locations, (String)"locations must not be null");
        try {
            ConfigurableEnvironment environment = context.getEnvironment();
            for (String location : locations) {
                String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                Resource resource = context.getResource(resolvedLocation);
                environment.getPropertySources().addFirst((PropertySource)new ResourcePropertySource(resource));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to add PropertySource to Environment", e);
        }
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableApplicationContext context, String[] inlinedProperties) {
        Assert.notNull((Object)context, (String)"context must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"inlinedProperties must not be null");
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment(context.getEnvironment(), inlinedProperties);
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableEnvironment environment, String[] inlinedProperties) {
        Assert.notNull((Object)environment, (String)"environment must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"inlinedProperties must not be null");
        if (!ObjectUtils.isEmpty((Object[])inlinedProperties)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding inlined properties to environment: " + ObjectUtils.nullSafeToString((Object[])inlinedProperties));
            }
            MapPropertySource ps = new MapPropertySource(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME, TestPropertySourceUtils.convertInlinedPropertiesToMap(inlinedProperties));
            environment.getPropertySources().addFirst((PropertySource)ps);
        }
    }

    public static Map<String, Object> convertInlinedPropertiesToMap(String[] inlinedProperties) {
        Assert.notNull((Object)inlinedProperties, (String)"inlinedProperties must not be null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Properties props = new Properties();
        for (String pair : inlinedProperties) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                props.load(new StringReader(pair));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load test environment property from [" + pair + "].", e);
            }
            Assert.state((props.size() == 1 ? 1 : 0) != 0, (String)("Failed to load exactly one test environment property from [" + pair + "]."));
            for (String name : props.stringPropertyNames()) {
                map.put(name, props.getProperty(name));
            }
            props.clear();
        }
        return map;
    }
}

