/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class TestPropertySourceAttributes {
    private static final Log logger = LogFactory.getLog(TestPropertySourceAttributes.class);
    private final Class<?> declaringClass;
    private final String[] locations;
    private final boolean inheritLocations;
    private final String[] properties;
    private final boolean inheritProperties;

    TestPropertySourceAttributes(Class<?> declaringClass, AnnotationAttributes annAttrs) {
        this(declaringClass, TestPropertySourceAttributes.resolveLocations(declaringClass, annAttrs.getStringArray("locations"), annAttrs.getStringArray("value")), annAttrs.getBoolean("inheritLocations"), annAttrs.getStringArray("properties"), annAttrs.getBoolean("inheritProperties"));
    }

    private TestPropertySourceAttributes(Class<?> declaringClass, String[] locations, boolean inheritLocations, String[] properties, boolean inheritProperties) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        if (ObjectUtils.isEmpty((Object[])locations) && ObjectUtils.isEmpty((Object[])properties)) {
            locations = new String[]{TestPropertySourceAttributes.detectDefaultPropertiesFile(declaringClass)};
        }
        this.declaringClass = declaringClass;
        this.locations = locations;
        this.inheritLocations = inheritLocations;
        this.properties = properties;
        this.inheritProperties = inheritProperties;
    }

    Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    String[] getLocations() {
        return this.locations;
    }

    boolean isInheritLocations() {
        return this.inheritLocations;
    }

    String[] getProperties() {
        return this.properties;
    }

    boolean isInheritProperties() {
        return this.inheritProperties;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", (Object)this.declaringClass.getName()).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("inheritLocations", this.inheritLocations).append("properties", (Object)ObjectUtils.nullSafeToString((Object[])this.properties)).append("inheritProperties", this.inheritProperties).toString();
    }

    private static String[] resolveLocations(Class<?> declaringClass, String[] locations, String[] value) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        if (!ObjectUtils.isEmpty((Object[])value) && !ObjectUtils.isEmpty((Object[])locations)) {
            String msg = String.format("Class [%s] has been configured with @TestPropertySource's 'value' [%s] and 'locations' [%s] attributes. Only one declaration of resource locations is permitted per @TestPropertySource annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])value), ObjectUtils.nullSafeToString((Object[])locations));
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        if (!ObjectUtils.isEmpty((Object[])value)) {
            locations = value;
        }
        return locations;
    }

    private static String detectDefaultPropertiesFile(Class<?> testClass) {
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)testClass.getName()) + ".properties";
        String prefixedResourcePath = "classpath:" + resourcePath;
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (classPathResource.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Detected default properties file \"%s\" for test class [%s]", prefixedResourcePath, testClass.getName()));
            }
            return prefixedResourcePath;
        }
        String msg = String.format("Could not detect default properties file for test [%s]: %s does not exist. Either declare the 'locations' or 'properties' attributes of @TestPropertySource or make the default properties file available.", testClass.getName(), classPathResource);
        logger.error(msg);
        throw new IllegalStateException(msg);
    }
}

