/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);

    private ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        HashSet<String> activeProfiles = new HashSet<String>();
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug(String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            String msg;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            Class<?> declaringClass = descriptor.getDeclaringClass();
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ActiveProfiles attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
            }
            ActiveProfilesUtils.validateActiveProfilesConfiguration(declaringClass, annAttrs);
            Class<DefaultActiveProfilesResolver> resolverClass = annAttrs.getClass("resolver");
            if (ActiveProfilesResolver.class.equals((Object)resolverClass)) {
                resolverClass = DefaultActiveProfilesResolver.class;
            }
            ActiveProfilesResolver resolver = null;
            try {
                resolver = (ActiveProfilesResolver)BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
            }
            catch (Exception e) {
                msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s].", resolverClass.getName(), rootDeclaringClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg, e);
            }
            String[] profiles = resolver.resolve(rootDeclaringClass);
            if (profiles == null) {
                msg = String.format("ActiveProfilesResolver [%s] returned a null array of bean definition profiles.", resolverClass.getName());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            for (String profile : profiles) {
                if (!StringUtils.hasText((String)profile)) continue;
                activeProfiles.add(profile.trim());
            }
            descriptor = annAttrs.getBoolean("inheritProfiles") ? MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }

    private static void validateActiveProfilesConfiguration(Class<?> declaringClass, AnnotationAttributes annAttrs) {
        boolean profilesDeclared;
        Object[] valueProfiles = annAttrs.getStringArray("value");
        Object[] profiles = annAttrs.getStringArray("profiles");
        boolean valueDeclared = !ObjectUtils.isEmpty((Object[])valueProfiles);
        boolean bl = profilesDeclared = !ObjectUtils.isEmpty((Object[])profiles);
        if (valueDeclared && profilesDeclared) {
            String msg = String.format("Class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])valueProfiles), ObjectUtils.nullSafeToString((Object[])profiles));
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
    }
}

