/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.jdbc;

import java.lang.reflect.Method;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.jdbc.MergedSqlConfig;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.jdbc.SqlConfig;
import org.springframework.test.context.jdbc.SqlGroup;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.TestContextTransactionUtils;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class SqlScriptsTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(SqlScriptsTestExecutionListener.class);

    @Override
    public final int getOrder() {
        return 5000;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.executeSqlScripts(testContext, Sql.ExecutionPhase.BEFORE_TEST_METHOD);
    }

    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        this.executeSqlScripts(testContext, Sql.ExecutionPhase.AFTER_TEST_METHOD);
    }

    private void executeSqlScripts(TestContext testContext, Sql.ExecutionPhase executionPhase) throws Exception {
        boolean classLevel = false;
        Set sqlAnnotations = AnnotationUtils.getRepeatableAnnotation((Method)testContext.getTestMethod(), SqlGroup.class, Sql.class);
        if (sqlAnnotations.isEmpty() && !(sqlAnnotations = AnnotationUtils.getRepeatableAnnotation(testContext.getTestClass(), SqlGroup.class, Sql.class)).isEmpty()) {
            classLevel = true;
        }
        for (Sql sql : sqlAnnotations) {
            this.executeSqlScripts(sql, executionPhase, testContext, classLevel);
        }
    }

    private void executeSqlScripts(Sql sql, Sql.ExecutionPhase executionPhase, TestContext testContext, boolean classLevel) throws Exception {
        boolean newTxRequired;
        if (executionPhase != sql.executionPhase()) {
            return;
        }
        MergedSqlConfig mergedSqlConfig = new MergedSqlConfig(sql.config(), testContext.getTestClass());
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Processing %s for execution phase [%s] and test context %s.", new Object[]{mergedSqlConfig, executionPhase, testContext}));
        }
        final ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setSqlScriptEncoding(mergedSqlConfig.getEncoding());
        populator.setSeparator(mergedSqlConfig.getSeparator());
        populator.setCommentPrefix(mergedSqlConfig.getCommentPrefix());
        populator.setBlockCommentStartDelimiter(mergedSqlConfig.getBlockCommentStartDelimiter());
        populator.setBlockCommentEndDelimiter(mergedSqlConfig.getBlockCommentEndDelimiter());
        populator.setContinueOnError(mergedSqlConfig.getErrorMode() == SqlConfig.ErrorMode.CONTINUE_ON_ERROR);
        populator.setIgnoreFailedDrops(mergedSqlConfig.getErrorMode() == SqlConfig.ErrorMode.IGNORE_FAILED_DROPS);
        Object[] scripts = this.getScripts(sql, testContext, classLevel);
        scripts = TestContextResourceUtils.convertToClasspathResourcePaths(testContext.getTestClass(), (String[])scripts);
        populator.setScripts(TestContextResourceUtils.convertToResources((ResourceLoader)testContext.getApplicationContext(), (String[])scripts));
        if (logger.isDebugEnabled()) {
            logger.debug("Executing SQL scripts: " + ObjectUtils.nullSafeToString((Object[])scripts));
        }
        String dsName = mergedSqlConfig.getDataSource();
        String tmName = mergedSqlConfig.getTransactionManager();
        DataSource dataSource = TestContextTransactionUtils.retrieveDataSource(testContext, dsName);
        PlatformTransactionManager transactionManager = TestContextTransactionUtils.retrieveTransactionManager(testContext, tmName);
        boolean bl = newTxRequired = mergedSqlConfig.getTransactionMode() == SqlConfig.TransactionMode.ISOLATED;
        if (transactionManager == null) {
            if (newTxRequired) {
                throw new IllegalStateException(String.format("Failed to execute SQL scripts for test context %s: cannot execute SQL scripts using Transaction Mode [%s] without a PlatformTransactionManager.", new Object[]{testContext, SqlConfig.TransactionMode.ISOLATED}));
            }
            if (dataSource == null) {
                throw new IllegalStateException(String.format("Failed to execute SQL scripts for test context %s: supply at least a DataSource or PlatformTransactionManager.", testContext));
            }
            populator.execute(dataSource);
        } else {
            DataSource dataSourceFromTxMgr = this.getDataSourceFromTransactionManager(transactionManager);
            if (dataSource != null && dataSourceFromTxMgr != null && !dataSource.equals(dataSourceFromTxMgr)) {
                throw new IllegalStateException(String.format("Failed to execute SQL scripts for test context %s: the configured DataSource [%s] (named '%s') is not the one associated with transaction manager [%s] (named '%s').", testContext, dataSource.getClass().getName(), dsName, transactionManager.getClass().getName(), tmName));
            }
            if (dataSource == null && (dataSource = dataSourceFromTxMgr) == null) {
                throw new IllegalStateException(String.format("Failed to execute SQL scripts for test context %s: could not obtain DataSource from transaction manager [%s] (named '%s').", testContext, transactionManager.getClass().getName(), tmName));
            }
            final DataSource finalDataSource = dataSource;
            int propagation = newTxRequired ? 3 : 0;
            TransactionAttribute transactionAttribute = TestContextTransactionUtils.createDelegatingTransactionAttribute(testContext, (TransactionAttribute)new DefaultTransactionAttribute(propagation));
            new TransactionTemplate(transactionManager, (TransactionDefinition)transactionAttribute).execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                public void doInTransactionWithoutResult(TransactionStatus status) {
                    populator.execute(finalDataSource);
                }
            });
        }
    }

    private DataSource getDataSourceFromTransactionManager(PlatformTransactionManager transactionManager) {
        try {
            Method getDataSourceMethod = transactionManager.getClass().getMethod("getDataSource", new Class[0]);
            Object obj = ReflectionUtils.invokeMethod((Method)getDataSourceMethod, (Object)transactionManager);
            if (obj instanceof DataSource) {
                return (DataSource)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String[] getScripts(Sql sql, TestContext testContext, boolean classLevel) {
        boolean valueDeclared;
        Object[] scripts = sql.scripts();
        Object[] value = sql.value();
        boolean scriptsDeclared = !ObjectUtils.isEmpty((Object[])scripts);
        boolean bl = valueDeclared = !ObjectUtils.isEmpty((Object[])value);
        if (valueDeclared && scriptsDeclared) {
            String elementType = classLevel ? "class" : "method";
            String elementName = classLevel ? testContext.getTestClass().getName() : testContext.getTestMethod().toString();
            String msg = String.format("Test %s [%s] has been configured with @Sql's 'value' [%s] and 'scripts' [%s] attributes. Only one declaration of SQL script paths is permitted per @Sql annotation.", elementType, elementName, ObjectUtils.nullSafeToString((Object[])value), ObjectUtils.nullSafeToString((Object[])scripts));
            logger.error(msg);
            throw new IllegalStateException(msg);
        }
        if (valueDeclared) {
            scripts = value;
        }
        if (ObjectUtils.isEmpty((Object[])scripts)) {
            scripts = new String[]{this.detectDefaultScript(testContext, classLevel)};
        }
        return scripts;
    }

    private String detectDefaultScript(TestContext testContext, boolean classLevel) {
        Class<?> clazz = testContext.getTestClass();
        Method method = testContext.getTestMethod();
        String elementType = classLevel ? "class" : "method";
        String elementName = classLevel ? clazz.getName() : method.toString();
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)clazz.getName());
        if (!classLevel) {
            resourcePath = resourcePath + "." + method.getName();
        }
        resourcePath = resourcePath + ".sql";
        String prefixedResourcePath = "classpath:" + resourcePath;
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (classPathResource.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("Detected default SQL script \"%s\" for test %s [%s]", prefixedResourcePath, elementType, elementName));
            }
            return prefixedResourcePath;
        }
        String msg = String.format("Could not detect default SQL script for test %s [%s]: %s does not exist. Either declare scripts via @Sql or make the default SQL script available.", elementType, elementName, classPathResource);
        logger.error(msg);
        throw new IllegalStateException(msg);
    }
}

