/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.context.BootstrapUtils;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.DefaultBootstrapContext;
import org.springframework.test.context.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.DefaultTestContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.Assert;

public class TestContextManager {
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    static final ContextCache contextCache = new ContextCache();
    private final TestContext testContext;
    private final TestContextBootstrapper testContextBootstrapper;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        DefaultCacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate = new DefaultCacheAwareContextLoaderDelegate(contextCache);
        DefaultBootstrapContext bootstrapContext = new DefaultBootstrapContext(testClass, cacheAwareContextLoaderDelegate);
        this.testContextBootstrapper = BootstrapUtils.resolveTestContextBootstrapper(bootstrapContext);
        this.testContext = new DefaultTestContext(this.testContextBootstrapper);
        this.registerTestExecutionListeners(this.testContextBootstrapper.getTestExecutionListeners());
    }

    protected final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(List<TestExecutionListener> testExecutionListeners) {
        this.registerTestExecutionListeners(testExecutionListeners.toArray(new TestExecutionListener[testExecutionListeners.size()]));
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace("Registering TestExecutionListener: " + listener);
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace("beforeTestClass(): class [" + testClass.getName() + "]");
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before class' callback for test class [" + testClass + "]", ex);
                throw ex;
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("prepareTestInstance(): instance [" + testInstance + "]");
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Exception ex) {
                logger.error("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]", ex);
                throw ex;
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull((Object)testInstance, (String)"Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]");
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]", ex);
                throw ex;
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]");
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        Exception afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]", ex);
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            throw afterTestMethodException;
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace("afterTestClass(): class [" + testClass.getName() + "]");
        }
        this.getTestContext().updateState(null, null, null);
        Exception afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after class' callback for test class [" + testClass + "]", ex);
                if (afterTestClassException != null) continue;
                afterTestClassException = ex;
            }
        }
        if (afterTestClassException != null) {
            throw afterTestClassException;
        }
    }
}

