/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.BootstrapWith;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.util.ClassUtils;

abstract class BootstrapUtils {
    private static final String DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME = "org.springframework.test.context.support.DefaultTestContextBootstrapper";
    private static final Log logger = LogFactory.getLog(BootstrapUtils.class);

    private BootstrapUtils() {
    }

    static TestContextBootstrapper resolveTestContextBootstrapper(BootstrapContext bootstrapContext) {
        Class<?> testClass = bootstrapContext.getTestClass();
        Class<? extends TestContextBootstrapper> clazz = null;
        try {
            BootstrapWith bootstrapWith = (BootstrapWith)AnnotationUtils.findAnnotation(testClass, BootstrapWith.class);
            clazz = bootstrapWith != null && !TestContextBootstrapper.class.equals(bootstrapWith.value()) ? bootstrapWith.value() : ClassUtils.forName((String)DEFAULT_TEST_CONTEXT_BOOTSTRAPPER_CLASS_NAME, (ClassLoader)BootstrapUtils.class.getClassLoader());
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Instantiating TestContextBootstrapper from class [%s]", clazz.getName()));
            }
            TestContextBootstrapper testContextBootstrapper = (TestContextBootstrapper)BeanUtils.instantiateClass(clazz, TestContextBootstrapper.class);
            testContextBootstrapper.setBootstrapContext(bootstrapContext);
            return testContextBootstrapper;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not load TestContextBootstrapper [" + clazz + "]. Specify @BootstrapWith's 'value' attribute " + "or make the default bootstrapper class available.", t);
        }
    }
}

