/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={})
public class FileLocator {
    private static final ReentrantLock _lock = new ReentrantLock(true);
    private static volatile ServiceTrackerMap<String, URLConverter> _serviceTrackerMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL resolve(URL url) throws IOException {
        String protocol = url.getProtocol();
        _lock.lock();
        try {
            URLConverter converter;
            if (_serviceTrackerMap == null) {
                Bundle bundle = FrameworkUtil.getBundle(FileLocator.class);
                _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(bundle.getBundleContext(), URLConverter.class, "protocol");
            }
            if ((converter = _serviceTrackerMap.getService(protocol)) == null) {
                URL uRL = url;
                return uRL;
            }
            URL uRL = converter.resolve(url);
            return uRL;
        }
        finally {
            _lock.unlock();
        }
    }

    @Deactivate
    protected void deactivate() {
        _lock.lock();
        try {
            if (_serviceTrackerMap != null) {
                _serviceTrackerMap.close();
                _serviceTrackerMap = null;
            }
        }
        finally {
            _lock.unlock();
        }
    }
}

