/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.Bayeux;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.HttpClientTransport;
import org.cometd.client.transport.MessageClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.client.transport.TransportRegistry;
import org.cometd.common.AbstractClientSession;
import org.cometd.common.AsyncFoldLeft;
import org.cometd.common.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BayeuxClient
extends AbstractClientSession
implements Bayeux {
    public static final String BACKOFF_INCREMENT_OPTION = "backoffIncrement";
    public static final String MAX_BACKOFF_OPTION = "maxBackoff";
    public static final String BAYEUX_VERSION = "1.0";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass().getName() + "." + Integer.toHexString(System.identityHashCode(this)));
    private final TransportRegistry transportRegistry = new TransportRegistry();
    private final Map<String, Object> options = new ConcurrentHashMap<String, Object>();
    private final List<Message.Mutable> messageQueue = new ArrayList<Message.Mutable>(32);
    private final CookieStore cookieStore = new CookieManager().getCookieStore();
    private final TransportListener messageListener = new MessageTransportListener();
    private final SessionState sessionState = new SessionState();
    private final String url;
    private ScheduledExecutorService scheduler;
    private long backoffIncrement;
    private long maxBackoff;

    public BayeuxClient(String url, ClientTransport transport, ClientTransport ... transports) {
        this(url, (ScheduledExecutorService)null, transport, transports);
    }

    public BayeuxClient(String url, ScheduledExecutorService scheduler, ClientTransport transport, ClientTransport ... transports) {
        this.url = Objects.requireNonNull(url);
        this.scheduler = scheduler;
        Objects.requireNonNull(transport);
        this.transportRegistry.add(transport);
        for (ClientTransport t : transports) {
            this.transportRegistry.add(t);
        }
        for (String transportName : this.transportRegistry.getKnownTransports()) {
            ClientTransport clientTransport = this.transportRegistry.getTransport(transportName);
            clientTransport.setOption("url", url);
            if (clientTransport instanceof MessageClientTransport) {
                ((MessageClientTransport)((Object)clientTransport)).setMessageTransportListener(this.messageListener);
            }
            if (!(clientTransport instanceof HttpClientTransport)) continue;
            HttpClientTransport httpTransport = (HttpClientTransport)clientTransport;
            httpTransport.setCookieStore(this.cookieStore);
        }
    }

    public String getURL() {
        return this.url;
    }

    public long getBackoff() {
        return this.sessionState.getBackOff();
    }

    public long getBackoffIncrement() {
        return this.backoffIncrement;
    }

    public long getMaxBackoff() {
        return this.maxBackoff;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public HttpCookie getCookie(String name) {
        for (HttpCookie cookie : this.getCookieStore().get(URI.create(this.getURL()))) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public void putCookie(HttpCookie cookie) {
        URI uri = URI.create(this.getURL());
        if (cookie.getPath() == null) {
            String path = uri.getPath();
            path = path == null || !path.contains("/") ? "/" : path.substring(0, path.lastIndexOf("/") + 1);
            cookie.setPath(path);
        }
        if (cookie.getDomain() == null) {
            cookie.setDomain(uri.getHost());
        }
        this.getCookieStore().add(uri, cookie);
    }

    @Override
    public String getId() {
        return this.sessionState.getSessionId();
    }

    @Override
    public boolean isHandshook() {
        State state = this.getState();
        return state == State.HANDSHAKEN || state == State.CONNECTING || state == State.CONNECTED || state == State.UNCONNECTED;
    }

    @Override
    public boolean isConnected() {
        return this.getState() == State.CONNECTED;
    }

    public boolean isDisconnected() {
        State state = this.getState();
        return state == State.TERMINATING || state == State.DISCONNECTED;
    }

    protected State getState() {
        return this.sessionState.getState();
    }

    @Deprecated
    public void handshake(ClientSessionChannel.MessageListener callback) {
        this.handshake(null, (Message message) -> callback.onMessage(this.getChannel("/meta/handshake"), message));
    }

    public void handshake(ClientSession.MessageListener callback) {
        this.handshake(null, callback);
    }

    @Override
    public void handshake(Map<String, Object> fields, ClientSession.MessageListener callback) {
        if (this.getState() != State.DISCONNECTED) {
            throw new IllegalStateException();
        }
        this.sessionState.submit(() -> this.sessionState.handshaking(fields, callback));
    }

    public State handshake(long waitMs) {
        return this.handshake(null, waitMs);
    }

    public State handshake(Map<String, Object> template, long waitMs) {
        this.handshake(template);
        this.waitFor(waitMs, State.CONNECTING, State.CONNECTED, State.DISCONNECTED);
        return this.getState();
    }

    protected void sendHandshake() {
        List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
        ArrayList<String> transportNames = new ArrayList<String>(transports.size());
        for (ClientTransport transport : transports) {
            transportNames.add(transport.getName());
        }
        Message.Mutable message = this.newMessage();
        Map handshakeFields = this.sessionState.getHandshakeFields();
        if (handshakeFields != null) {
            message.putAll(handshakeFields);
        }
        String messageId = this.newMessageId();
        message.setId(messageId);
        message.setChannel("/meta/handshake");
        message.put("supportedConnectionTypes", transportNames);
        message.put("version", BAYEUX_VERSION);
        this.registerCallback(messageId, this.sessionState.getHandshakeCallback());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Handshaking on transport {}: {}", (Object)this.getTransport(), (Object)message);
        }
        ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
        messages.add(message);
        this.sendMessages(messages, Promise.complete((r, x) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} handshake {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long waitMs, State state, State ... states) {
        ArrayList<State> waitForStates = new ArrayList<State>();
        waitForStates.add(state);
        waitForStates.addAll(Arrays.asList(states));
        SessionState sessionState = this.sessionState;
        synchronized (sessionState) {
            while (waitMs > 0L) {
                if (this.sessionState.isIdle()) {
                    State currentState = this.getState();
                    for (State s : waitForStates) {
                        if (!currentState.implies(s)) continue;
                        return true;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waiting {}ms for {}", (Object)waitMs, (Object)waitForStates);
                }
                long start = System.nanoTime();
                if (this.sessionState.await(waitMs)) break;
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Waited {}/{}ms for {}, state is {}", new Object[]{elapsed, waitMs, waitForStates, this.sessionState.getState()});
                }
                waitMs -= elapsed;
            }
            return false;
        }
    }

    protected void sendConnect() {
        ClientTransport transport = this.getTransport();
        if (transport == null) {
            return;
        }
        Message.Mutable message = this.newMessage();
        message.setId(this.newMessageId());
        message.setChannel("/meta/connect");
        message.put("connectionType", transport.getName());
        State state = this.getState();
        if (state == State.CONNECTING || state == State.UNCONNECTED) {
            message.getAdvice(true).put("timeout", 0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connecting, transport {}", (Object)transport);
        }
        ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
        messages.add(message);
        this.sendMessages(messages, Promise.complete((r, x) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} connect {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
            }
        }));
    }

    @Override
    protected ChannelId newChannelId(String channelId) {
        AbstractClientSession.AbstractSessionChannel channel = (AbstractClientSession.AbstractSessionChannel)this.getChannels().get(channelId);
        return channel == null ? new ChannelId(channelId) : channel.getChannelId();
    }

    @Override
    protected AbstractClientSession.AbstractSessionChannel newChannel(ChannelId channelId) {
        return new BayeuxClientChannel(channelId);
    }

    @Override
    protected void sendBatch() {
        List<Message.Mutable> messages;
        if (this.canSend() && !(messages = this.takeMessages()).isEmpty()) {
            this.sendMessages(messages, Promise.complete((r, x) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} batch {}", (Object)(x == null ? "Sent" : "Failed"), (Object)messages);
                }
            }));
        }
    }

    protected void sendMessages(List<Message.Mutable> messages, Promise<Boolean> promise) {
        AsyncFoldLeft.run(messages, new ArrayList(messages.size()), (toSend, message, loop) -> {
            String messageId = message.getId();
            message.setClientId(this.sessionState.sessionId);
            this.extendOutgoing((Message.Mutable)message, Promise.from(extPass -> {
                message.setId(messageId);
                if (extPass.booleanValue()) {
                    toSend.add(message);
                }
                loop.proceed(toSend);
            }, loop::fail));
        }, Promise.from(toSend -> {
            List deleted = Collections.emptyList();
            if (toSend.size() != messages.size()) {
                deleted = new ArrayList(messages);
                deleted.removeAll((Collection<?>)toSend);
            }
            AsyncFoldLeft.run(deleted, null, (result, message, loop) -> {
                Message.Mutable failed = this.newMessage();
                failed.setId(message.getId());
                failed.setSuccessful(false);
                failed.setChannel(message.getChannel());
                if (message.containsKey("subscription")) {
                    failed.put("subscription", message.get("subscription"));
                }
                failed.put("error", "404::message_deleted");
                this.receive(failed, Promise.from(loop::proceed, loop::fail));
            }, Promise.from(r -> {
                if (toSend.isEmpty()) {
                    promise.succeed(false);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Sending messages {}", toSend);
                    }
                    promise.succeed(this.sessionState.send(this.messageListener, toSend));
                }
            }, promise::fail));
        }, promise::fail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message.Mutable> takeMessages() {
        ArrayList<Message.Mutable> messages;
        List<Message.Mutable> list = this.messageQueue;
        synchronized (list) {
            messages = new ArrayList<Message.Mutable>(this.messageQueue);
            this.messageQueue.clear();
        }
        return messages;
    }

    @Override
    public void disconnect(ClientSession.MessageListener callback) {
        this.sessionState.submit(() -> this.sessionState.disconnecting(callback));
    }

    public boolean disconnect(long timeout) {
        if (this.isDisconnected()) {
            return true;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ClientSessionChannel.MessageListener lastConnectListener = (channel, message) -> {
            Map<String, Object> advice = message.getAdvice();
            if (!message.isSuccessful() || advice != null && "none".equals(advice.get("reconnect"))) {
                latch.countDown();
            }
        };
        this.getChannel("/meta/connect").addListener(lastConnectListener);
        this.disconnect();
        boolean disconnected = this.waitFor(timeout, State.DISCONNECTED, new State[0]);
        try {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
        this.getChannel("/meta/connect").removeListener(lastConnectListener);
        this.sessionState.submit(() -> this.sessionState.terminating());
        return disconnected;
    }

    public void abort() {
        this.sessionState.submit(() -> {
            if (this.sessionState.update(State.TERMINATING)) {
                this.sessionState.terminate(true);
            }
        });
    }

    private void processMessages(List<Message.Mutable> messages) {
        block10: for (Message.Mutable message : messages) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Processing {}", (Object)message);
            }
            switch (message.getChannel()) {
                case "/meta/handshake": {
                    this.processHandshake(message);
                    continue block10;
                }
                case "/meta/connect": {
                    this.processConnect(message);
                    continue block10;
                }
                case "/meta/disconnect": {
                    this.processDisconnect(message);
                    continue block10;
                }
            }
            this.processMessage(message);
        }
    }

    protected void messagesFailure(Throwable cause, List<? extends Message> messages) {
        block10: for (Message message : messages) {
            ClientTransport transport;
            Map<String, Object> fields;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Failing {}", (Object)message);
            }
            Message.Mutable failed = this.newMessage();
            failed.setId(message.getId());
            failed.setSuccessful(false);
            failed.setChannel(message.getChannel());
            if (message.containsKey("subscription")) {
                failed.put("subscription", message.get("subscription"));
            }
            HashMap<String, Object> failure = new HashMap<String, Object>();
            failed.put("failure", failure);
            failure.put("message", message);
            if (cause != null) {
                failure.put("exception", cause);
            }
            if (cause instanceof TransportException && (fields = ((TransportException)cause).getFields()) != null) {
                failure.putAll(fields);
            }
            if ((transport = this.getTransport()) != null) {
                failure.put("connectionType", transport.getName());
            }
            switch (message.getChannel()) {
                case "/meta/handshake": {
                    this.handshakeFailure(failed, cause);
                    continue block10;
                }
                case "/meta/connect": {
                    this.connectFailure(failed, cause);
                    continue block10;
                }
                case "/meta/disconnect": {
                    this.disconnectFailure(failed, cause);
                    continue block10;
                }
            }
            this.messageFailure(failed, cause);
        }
    }

    protected void processHandshake(Message.Mutable handshake) {
        if (handshake.isSuccessful()) {
            ClientTransport oldTransport = this.getTransport();
            Object field = handshake.get("supportedConnectionTypes");
            Object[] serverTransports = field instanceof List ? ((List)field).toArray() : (Object[])field;
            List<ClientTransport> negotiatedTransports = this.transportRegistry.negotiate(serverTransports, BAYEUX_VERSION);
            if (negotiatedTransports.isEmpty()) {
                ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
                failureInfo.transport = null;
                failureInfo.cause = null;
                failureInfo.error = String.format("405:c%s,s%s:no_transport", this.getAllowedTransports(), Arrays.toString(serverTransports));
                failureInfo.action = "none";
                handshake.setSuccessful(false);
                handshake.put("error", failureInfo.error);
                this.failHandshake(handshake, failureInfo);
            } else {
                Number messagesField = (Number)handshake.get("x-messages");
                int messages = messagesField == null ? 0 : messagesField.intValue();
                ClientTransport newTransport = negotiatedTransports.get(0);
                if (newTransport != oldTransport) {
                    this.prepareTransport(oldTransport, newTransport);
                }
                this.sessionState.submit(() -> this.sessionState.handshaken(newTransport, handshake, messages));
            }
        } else {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = this.getTransport();
            failureInfo.cause = null;
            failureInfo.error = null;
            failureInfo.action = this.sessionState.getAdviceAction(handshake.getAdvice(), "handshake");
            this.failHandshake(handshake, failureInfo);
        }
    }

    private void handshakeFailure(Message.Mutable handshake, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = null;
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "handshake";
        this.failHandshake(handshake, failureInfo);
    }

    private void failHandshake(Message.Mutable handshake, ClientTransport.FailureInfo failureInfo) {
        this.receive(handshake, Promise.from(r -> {
            if (this.isDisconnected()) {
                failureInfo.action = "none";
            }
            this.onTransportFailure(handshake, failureInfo, this.sessionState);
        }, x -> this.logger.info("Failure while receiving " + handshake, (Throwable)x)));
    }

    protected void processConnect(Message.Mutable connect) {
        if (this.sessionState.matchMetaConnect(connect)) {
            if (connect.isSuccessful()) {
                this.receive(connect, Promise.from(r -> this.sessionState.submit(() -> this.sessionState.connected(connect)), x -> this.logger.info("Failure while receiving " + connect, (Throwable)x)));
            } else {
                ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
                failureInfo.transport = this.getTransport();
                failureInfo.cause = null;
                failureInfo.error = null;
                failureInfo.action = this.sessionState.getAdviceAction(connect.getAdvice(), "retry");
                this.failConnect(connect, failureInfo);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mismatched /meta/connect reply: expected reply for {}, received {}", (Object)this.sessionState.getMetaConnect(), (Object)connect);
        }
    }

    private void connectFailure(Message.Mutable connect, Throwable failure) {
        if (this.sessionState.matchMetaConnect(connect)) {
            ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
            failureInfo.transport = null;
            failureInfo.cause = failure;
            failureInfo.error = null;
            failureInfo.action = "retry";
            this.failConnect(connect, failureInfo);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mismatched /meta/connect failure: expected {}, got {}", (Object)this.sessionState.getMetaConnect(), (Object)connect);
        }
    }

    private void failConnect(Message.Mutable connect, ClientTransport.FailureInfo failureInfo) {
        this.receive(connect, Promise.from(r -> {
            if (this.isDisconnected()) {
                failureInfo.action = "none";
            }
            this.onTransportFailure(connect, failureInfo, this.sessionState);
        }, x -> this.logger.info("Failure while receiving " + connect, (Throwable)x)));
    }

    protected void processDisconnect(Message.Mutable disconnect) {
        if (disconnect.isSuccessful()) {
            this.receive(disconnect, Promise.complete((r, x) -> this.sessionState.submit(() -> this.sessionState.terminating())));
        } else {
            this.disconnectFailure(disconnect, null);
        }
    }

    private void disconnectFailure(Message.Mutable disconnect, Throwable failure) {
        ClientTransport.FailureInfo failureInfo = new ClientTransport.FailureInfo();
        failureInfo.transport = this.getTransport();
        failureInfo.cause = failure;
        failureInfo.error = null;
        failureInfo.action = "none";
        this.failDisconnect(disconnect, failureInfo);
    }

    private void failDisconnect(Message.Mutable disconnect, ClientTransport.FailureInfo failureInfo) {
        this.receive(disconnect, Promise.complete((r, x) -> this.onTransportFailure(disconnect, failureInfo, this.sessionState)));
    }

    protected void processMessage(Message.Mutable message) {
        this.receive(message, Promise.complete((r, x) -> {
            if (this.getState() == State.HANDSHAKEN) {
                this.sessionState.submit(() -> this.sessionState.afterHandshaken());
            }
        }));
    }

    private void messageFailure(Message.Mutable message, Throwable failure) {
        this.failMessage(message);
    }

    private void failMessage(Message.Mutable message) {
        this.receive(message, Promise.from(r -> {}, x -> this.logger.info("Failure while receiving " + message, (Throwable)x)));
    }

    protected boolean scheduleHandshake(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled handshake in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(this::sendHandshake, interval, backOff);
    }

    protected boolean scheduleConnect(long interval, long backOff) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Scheduled connect in {}+{} ms", (Object)interval, (Object)backOff);
        }
        return this.scheduleAction(this::sendConnect, interval, backOff);
    }

    private boolean scheduleAction(Runnable action, long interval, long backoff) {
        ScheduledExecutorService scheduler = this.scheduler;
        if (scheduler != null) {
            try {
                scheduler.schedule(action, interval + backoff, TimeUnit.MILLISECONDS);
                return true;
            }
            catch (RejectedExecutionException x) {
                this.logger.trace("", x);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Could not schedule action {} to scheduler {}", (Object)action, (Object)scheduler);
        }
        return false;
    }

    @Override
    public List<String> getAllowedTransports() {
        return this.transportRegistry.getAllowedTransports();
    }

    @Override
    public Set<String> getKnownTransportNames() {
        return this.transportRegistry.getKnownTransports();
    }

    @Override
    public ClientTransport getTransport(String transport) {
        return this.transportRegistry.getTransport(transport);
    }

    public ClientTransport getTransport() {
        return this.sessionState.getTransport();
    }

    protected void initialize() {
        long maxBackoff;
        long backoffIncrement;
        Number value = (Number)this.getOption(BACKOFF_INCREMENT_OPTION);
        long l = backoffIncrement = value == null ? -1L : value.longValue();
        if (backoffIncrement < 0L) {
            backoffIncrement = 1000L;
        }
        this.backoffIncrement = backoffIncrement;
        value = (Number)this.getOption(MAX_BACKOFF_OPTION);
        long l2 = maxBackoff = value == null ? -1L : value.longValue();
        if (maxBackoff <= 0L) {
            maxBackoff = 30000L;
        }
        this.maxBackoff = maxBackoff;
        if (this.scheduler == null) {
            this.scheduler = new BayeuxClientScheduler();
        }
    }

    protected void terminate() {
        List<Message.Mutable> messages = this.takeMessages();
        this.messagesFailure(null, messages);
        this.cookieStore.removeAll();
        if (this.scheduler instanceof BayeuxClientScheduler) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    @Override
    public Object getOption(String qualifiedName) {
        return this.options.get(qualifiedName);
    }

    @Override
    public void setOption(String qualifiedName, Object value) {
        this.options.put(qualifiedName, value);
        for (String name : this.transportRegistry.getKnownTransports()) {
            ClientTransport transport = this.transportRegistry.getTransport(name);
            transport.setOption(qualifiedName, value);
        }
    }

    @Override
    public Set<String> getOptionNames() {
        return this.options.keySet();
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    protected void send(Message.Mutable message) {
        this.enqueueSend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueSend(Message.Mutable message) {
        if (this.canSend()) {
            ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
            messages.add(message);
            this.sendMessages(messages, Promise.complete((r, x) -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} message {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
                }
            }));
        } else {
            List<Message.Mutable> list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(message);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Enqueued message {} (batching: {})", (Object)message, (Object)this.isBatching());
            }
        }
    }

    private boolean canSend() {
        State state = this.getState();
        boolean handshaking = state == State.HANDSHAKING || state == State.REHANDSHAKING;
        return !this.isBatching() && !handshaking;
    }

    public void onSending(List<? extends Message> messages) {
    }

    public void onMessages(List<Message.Mutable> messages) {
    }

    public void onFailure(Throwable failure, List<? extends Message> messages) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Messages failed " + messages, failure);
        }
    }

    private void prepareTransport(ClientTransport oldTransport, ClientTransport newTransport) {
        if (oldTransport != null) {
            oldTransport.terminate();
        }
        newTransport.init();
    }

    protected void onTransportFailure(Message message, ClientTransport.FailureInfo failureInfo, ClientTransport.FailureHandler handler) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transport failure: {} for {}", (Object)failureInfo, (Object)message);
        }
        if ("none".equals(failureInfo.action)) {
            ClientTransport transport;
            if ("/meta/handshake".equals(message.getChannel()) && (transport = this.getTransport()) != null && failureInfo.transport == null) {
                this.onTransportFailure(transport.getName(), null, failureInfo.cause);
            }
        } else {
            failureInfo.delay = this.sessionState.getBackOff();
            if ("/meta/handshake".equals(message.getChannel())) {
                if (failureInfo.transport == null) {
                    List<ClientTransport> transports = this.transportRegistry.negotiate(this.getAllowedTransports().toArray(), BAYEUX_VERSION);
                    if (transports.isEmpty()) {
                        this.onTransportFailure(this.getTransport().getName(), null, failureInfo.cause);
                        failureInfo.action = "none";
                    } else {
                        ClientTransport oldTransport = this.getTransport();
                        ClientTransport newTransport = transports.get(0);
                        if (newTransport != oldTransport) {
                            this.prepareTransport(oldTransport, newTransport);
                        }
                        this.onTransportFailure(oldTransport.getName(), newTransport.getName(), failureInfo.cause);
                        failureInfo.transport = newTransport;
                        failureInfo.action = "handshake";
                    }
                }
                if (!"none".equals(failureInfo.action)) {
                    this.sessionState.increaseBackOff();
                }
            } else {
                this.sessionState.initUnconnectTime();
                if ("retry".equals(failureInfo.action)) {
                    failureInfo.delay = this.sessionState.increaseBackOff();
                    if (this.sessionState.nextConnectExceedsMaxInterval()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Switching to handshake retries");
                        }
                        failureInfo.action = "handshake";
                    }
                }
                if ("handshake".equals(failureInfo.action)) {
                    failureInfo.delay = 0L;
                    this.sessionState.resetBackOff();
                }
            }
        }
        handler.handle(failureInfo);
    }

    protected void onTransportFailure(String oldTransportName, String newTransportName, Throwable failure) {
    }

    public String toString() {
        return String.format("%s@%x[%s][%s]", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.sessionState);
    }

    private static class BayeuxClientScheduler
    extends ScheduledThreadPoolExecutor {
        public BayeuxClientScheduler() {
            super(1);
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.setRemoveOnCancelPolicy(true);
        }
    }

    private class SessionState
    implements ClientTransport.FailureHandler {
        private final Queue<Runnable> actions = new ArrayDeque<Runnable>();
        private State state = State.DISCONNECTED;
        private ClientTransport transport;
        private Map<String, Object> handshakeFields;
        private ClientSession.MessageListener handshakeCallback;
        private Map<String, Object> advice;
        private String sessionId;
        private long backOff;
        private long unconnectTime;
        private boolean active;
        private int handshakeMessages;
        private Message metaConnect;

        private SessionState() {
        }

        private void reset() {
            this.actions.clear();
            this.state = State.DISCONNECTED;
            this.transport = null;
            this.handshakeFields = null;
            this.handshakeCallback = null;
            this.advice = null;
            this.sessionId = null;
            this.backOff = 0L;
            this.unconnectTime = 0L;
            this.active = false;
            this.handshakeMessages = 0;
            this.metaConnect = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private State getState() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientTransport getTransport() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.transport;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getHandshakeFields() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.handshakeFields;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientSession.MessageListener getHandshakeCallback() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.handshakeCallback;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getAdvice() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.advice;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getSessionId() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.sessionId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.backOff;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getUnconnectTime() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.unconnectTime == 0L) {
                    return 0L;
                }
                return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.unconnectTime);
            }
        }

        private long getTimeout() {
            return this.getAdviceLong("timeout");
        }

        private long getInterval() {
            return this.getAdviceLong("interval");
        }

        private long getMaxInterval() {
            return this.getAdviceLong("maxInterval");
        }

        private String getAdviceAction(Map<String, Object> advice, String defaultAction) {
            String result = null;
            if (advice == null) {
                advice = this.getAdvice();
            }
            if (advice != null) {
                result = (String)advice.get("reconnect");
            }
            return result == null ? defaultAction : result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getAdviceLong(String field) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                long result = 0L;
                if (this.advice != null && this.advice.containsKey(field)) {
                    result = ((Number)this.advice.get(field)).longValue();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return Math.min(this.backOff + BayeuxClient.this.getBackoffIncrement(), BayeuxClient.this.getMaxBackoff());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long increaseBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.backOff = this.nextBackOff();
                return this.backOff;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetBackOff() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.backOff = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handshaking(Map<String, Object> handshakeFields, ClientSession.MessageListener handshakeCallback) {
            if (this.update(State.HANDSHAKING)) {
                BayeuxClient.this.initialize();
                List<String> allowedTransports = BayeuxClient.this.getAllowedTransports();
                ClientTransport transport = BayeuxClient.this.transportRegistry.negotiate(allowedTransports.toArray(), BayeuxClient.BAYEUX_VERSION).get(0);
                BayeuxClient.this.prepareTransport(null, transport);
                if (BayeuxClient.this.logger.isDebugEnabled()) {
                    BayeuxClient.this.logger.debug("Using initial transport {} from {}", (Object)transport.getName(), (Object)allowedTransports);
                }
                SessionState sessionState = this;
                synchronized (sessionState) {
                    this.transport = transport;
                    this.handshakeFields = handshakeFields;
                    this.handshakeCallback = handshakeCallback;
                }
                BayeuxClient.this.resetSubscriptions();
                BayeuxClient.this.sendHandshake();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rehandshaking(long backOff) {
            boolean result;
            State oldState;
            SessionState sessionState = this;
            synchronized (sessionState) {
                oldState = this.state;
                result = this.update(State.REHANDSHAKING);
            }
            if (result) {
                if (oldState != State.HANDSHAKING) {
                    BayeuxClient.this.resetSubscriptions();
                }
                BayeuxClient.this.scheduleHandshake(this.getInterval(), backOff);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handshaken(ClientTransport transport, Message.Mutable handshake, int messages) {
            boolean updated;
            SessionState sessionState = this;
            synchronized (sessionState) {
                updated = this.update(State.HANDSHAKEN);
                if (updated) {
                    this.transport = transport;
                    this.advice = handshake.getAdvice();
                    this.sessionId = handshake.getClientId();
                    this.handshakeMessages = messages;
                    this.backOff = 0L;
                }
            }
            if (updated) {
                BayeuxClient.this.receive(handshake, Promise.from(r -> {
                    BayeuxClient.this.sendBatch();
                    if (messages == 0) {
                        this.connecting();
                    }
                }, x -> BayeuxClient.this.logger.info("Failure while receiving " + handshake, (Throwable)x)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void afterHandshaken() {
            boolean connect = false;
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.getState() == State.HANDSHAKEN) {
                    if (this.handshakeMessages > 0) {
                        --this.handshakeMessages;
                    }
                    connect = this.handshakeMessages == 0;
                }
            }
            if (connect) {
                this.connecting();
            }
        }

        private void connecting() {
            if (this.update(State.CONNECTING)) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connected(Message connect) {
            boolean updated;
            SessionState sessionState = this;
            synchronized (sessionState) {
                updated = this.update(State.CONNECTED);
                if (updated) {
                    this.backOff = 0L;
                    this.unconnectTime = 0L;
                    Map<String, Object> advice = connect.getAdvice();
                    if (advice != null) {
                        this.advice = advice;
                    }
                }
            }
            if (updated) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), 0L);
            }
        }

        private void unconnected(long backOff) {
            if (this.update(State.UNCONNECTED)) {
                BayeuxClient.this.scheduleConnect(this.getInterval(), backOff);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean nextConnectExceedsMaxInterval() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                long maxInterval = this.getMaxInterval();
                if (maxInterval > 0L) {
                    long expiration = this.getTimeout() + this.getInterval() + maxInterval;
                    return this.getUnconnectTime() + this.getBackOff() > expiration;
                }
                return false;
            }
        }

        private void disconnecting(ClientSession.MessageListener callback) {
            if (this.update(State.DISCONNECTING)) {
                Message.Mutable message = BayeuxClient.this.newMessage();
                String messageId = BayeuxClient.this.newMessageId();
                message.setId(messageId);
                message.setChannel("/meta/disconnect");
                BayeuxClient.this.registerCallback(messageId, callback);
                ArrayList<Message.Mutable> messages = new ArrayList<Message.Mutable>(1);
                messages.add(message);
                BayeuxClient.this.sendMessages(messages, Promise.complete((r, x) -> {
                    if (BayeuxClient.this.logger.isDebugEnabled()) {
                        BayeuxClient.this.logger.debug("{} disconnect {}", (Object)(x == null ? "Sent" : "Failed"), (Object)message);
                    }
                }));
            }
        }

        private void terminating() {
            if (this.update(State.TERMINATING)) {
                this.terminate(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean update(State newState) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                State oldState = this.state;
                boolean result = this.state.isUpdateableTo(newState);
                if (result) {
                    this.state = newState;
                }
                if (BayeuxClient.this.logger.isDebugEnabled()) {
                    BayeuxClient.this.logger.debug("State {}updated: {} -> {}", new Object[]{result ? "" : "not ", oldState, newState});
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate(boolean abort) {
            if (abort) {
                this.transport.abort();
            } else {
                this.transport.terminate();
            }
            BayeuxClient.this.terminate();
            SessionState sessionState = this;
            synchronized (sessionState) {
                this.update(State.DISCONNECTED);
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void submit(Runnable action) {
            boolean empty;
            SessionState sessionState = this;
            synchronized (sessionState) {
                empty = this.actions.isEmpty();
                this.actions.offer(action);
            }
            if (empty && this.process()) {
                sessionState = this;
                synchronized (sessionState) {
                    if (BayeuxClient.this.logger.isDebugEnabled()) {
                        BayeuxClient.this.logger.debug("Notifying threads in waitFor()");
                    }
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean process() {
            boolean looping = false;
            while (true) {
                Runnable action;
                SessionState sessionState = this;
                synchronized (sessionState) {
                    if (!looping && this.active) {
                        return false;
                    }
                    action = this.actions.poll();
                    if (action == null) {
                        this.active = false;
                        return true;
                    }
                    if (!looping) {
                        looping = true;
                        this.active = true;
                    }
                }
                action.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean send(TransportListener messageListener, List<Message.Mutable> messages) {
            if (BayeuxClient.this.isDisconnected()) {
                BayeuxClient.this.messagesFailure(new TransportException(null), messages);
                return false;
            }
            for (Message.Mutable message : messages) {
                Message existing;
                if (!"/meta/connect".equals(message.getChannel())) continue;
                SessionState sessionState = this;
                synchronized (sessionState) {
                    existing = this.metaConnect;
                    this.metaConnect = message;
                }
                if (!BayeuxClient.this.logger.isDebugEnabled()) continue;
                if (existing != null) {
                    BayeuxClient.this.logger.debug("Overwriting existing /meta/connect {}", (Object)existing);
                }
                BayeuxClient.this.logger.debug("Sending /meta/connect {}", (Object)message);
            }
            this.transport.send(messageListener, messages);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean matchMetaConnect(Message.Mutable connect) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (State.DISCONNECTED.implies(this.state)) {
                    return true;
                }
                if (this.metaConnect != null && this.metaConnect.getId().equals(connect.getId())) {
                    this.metaConnect = null;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message getMetaConnect() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return this.metaConnect;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isIdle() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                return !this.active;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean await(long time) {
            SessionState sessionState = this;
            synchronized (sessionState) {
                try {
                    this.wait(time);
                    return false;
                }
                catch (InterruptedException x) {
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initUnconnectTime() {
            SessionState sessionState = this;
            synchronized (sessionState) {
                if (this.unconnectTime == 0L) {
                    this.unconnectTime = System.nanoTime();
                }
            }
        }

        @Override
        public void handle(ClientTransport.FailureInfo failureInfo) {
            if (BayeuxClient.this.logger.isDebugEnabled()) {
                BayeuxClient.this.logger.debug("Transport failure handling: {}", (Object)failureInfo);
            }
            this.submit(() -> {
                State newState = failureInfo.actionToState();
                SessionState sessionState = this;
                synchronized (sessionState) {
                    String url;
                    ClientTransport newTransport = failureInfo.transport;
                    if (newTransport != null) {
                        this.transport = newTransport;
                    }
                    if ((url = failureInfo.url) != null) {
                        this.transport.setURL(url);
                    }
                }
                switch (newState) {
                    case REHANDSHAKING: {
                        this.rehandshaking(failureInfo.delay);
                        break;
                    }
                    case UNCONNECTED: {
                        this.unconnected(failureInfo.delay);
                        break;
                    }
                    case TERMINATING: {
                        this.terminating();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            });
        }

        public String toString() {
            return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.state});
        }
    }

    protected class BayeuxClientChannel
    extends AbstractClientSession.AbstractSessionChannel {
        protected BayeuxClientChannel(ChannelId channelId) {
            super(BayeuxClient.this, channelId);
        }

        @Override
        public ClientSession getSession() {
            this.throwIfReleased();
            return BayeuxClient.this;
        }
    }

    private class MessageTransportListener
    implements TransportListener {
        private MessageTransportListener() {
        }

        @Override
        public void onSending(List<? extends Message> messages) {
            BayeuxClient.this.onSending(messages);
        }

        @Override
        public void onMessages(List<Message.Mutable> messages) {
            BayeuxClient.this.onMessages(messages);
            BayeuxClient.this.processMessages(messages);
        }

        @Override
        public void onFailure(Throwable failure, List<? extends Message> messages) {
            BayeuxClient.this.onFailure(failure, messages);
            BayeuxClient.this.messagesFailure(failure, messages);
        }
    }

    public static enum State {
        UNCONNECTED(new State[0]),
        HANDSHAKING(new State[0]),
        REHANDSHAKING(new State[0]),
        HANDSHAKEN(HANDSHAKING, REHANDSHAKING),
        CONNECTING(HANDSHAKING, REHANDSHAKING, HANDSHAKEN),
        CONNECTED(HANDSHAKING, REHANDSHAKING, HANDSHAKEN, CONNECTING),
        DISCONNECTING(new State[0]),
        TERMINATING(DISCONNECTING),
        DISCONNECTED(DISCONNECTING, TERMINATING);

        private final State[] implieds;

        private State(State ... implieds) {
            this.implieds = implieds;
        }

        private boolean implies(State state) {
            if (state == this) {
                return true;
            }
            for (State implied : this.implieds) {
                if (state != implied) continue;
                return true;
            }
            return false;
        }

        private boolean isUpdateableTo(State newState) {
            switch (this) {
                case DISCONNECTED: {
                    return newState == HANDSHAKING;
                }
                case HANDSHAKING: 
                case REHANDSHAKING: {
                    return EnumSet.of(REHANDSHAKING, HANDSHAKEN, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case HANDSHAKEN: {
                    return EnumSet.of(CONNECTING, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case CONNECTING: 
                case CONNECTED: 
                case UNCONNECTED: {
                    return EnumSet.of(REHANDSHAKING, CONNECTED, UNCONNECTED, DISCONNECTING, TERMINATING).contains((Object)newState);
                }
                case DISCONNECTING: {
                    return newState == TERMINATING;
                }
                case TERMINATING: {
                    return newState == DISCONNECTED;
                }
            }
            throw new IllegalStateException();
        }
    }
}

