/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.xstream.configurator;

import com.liferay.exportimport.kernel.xstream.XStreamAliasRegistryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.xstream.configurator.XStreamConfigurator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
@ProviderType
public class XStreamConfiguratorRegistryUtil {
    private static final AtomicLong _modifiedCount = new AtomicLong(0L);
    private static final Set<XStreamConfigurator> _xStreamConfigurators = Collections.newSetFromMap(new ConcurrentHashMap());
    private BundleContext _bundleContext;
    private ServiceTracker<XStreamConfigurator, XStreamConfigurator> _serviceTracker;

    public static ClassLoader getConfiguratorsClassLoader(ClassLoader masterClassLoader) {
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        Set<XStreamConfigurator> xStreamConfigurators = _xStreamConfigurators;
        for (XStreamConfigurator xStreamConfigurator : xStreamConfigurators) {
            Class<?> clazz = xStreamConfigurator.getClass();
            classLoaders.add(clazz.getClassLoader());
        }
        Map<Class<?>, String> aliases = XStreamAliasRegistryUtil.getAliases();
        if (!aliases.isEmpty()) {
            for (Class<?> clazz : aliases.keySet()) {
                classLoaders.add(clazz.getClassLoader());
            }
        }
        return AggregateClassLoader.getAggregateClassLoader(masterClassLoader, classLoaders.toArray(new ClassLoader[0]));
    }

    public static long getModifiedCount() {
        return _modifiedCount.get();
    }

    public static Set<XStreamConfigurator> getXStreamConfigurators() {
        return _xStreamConfigurators;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = new ServiceTracker(bundleContext, XStreamConfigurator.class, (ServiceTrackerCustomizer)new XStreamConfiguratorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class XStreamConfiguratorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<XStreamConfigurator, XStreamConfigurator> {
        private XStreamConfiguratorServiceTrackerCustomizer() {
        }

        public XStreamConfigurator addingService(ServiceReference<XStreamConfigurator> serviceReference) {
            XStreamConfigurator xStreamConfigurator = (XStreamConfigurator)XStreamConfiguratorRegistryUtil.this._bundleContext.getService(serviceReference);
            _xStreamConfigurators.add(xStreamConfigurator);
            _modifiedCount.getAndIncrement();
            return xStreamConfigurator;
        }

        public void modifiedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
            this.removedService(serviceReference, xStreamConfigurator);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<XStreamConfigurator> serviceReference, XStreamConfigurator xStreamConfigurator) {
            XStreamConfiguratorRegistryUtil.this._bundleContext.ungetService(serviceReference);
            _xStreamConfigurators.remove(xStreamConfigurator);
            _modifiedCount.getAndIncrement();
        }
    }
}

