/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.util.comparator;

import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiPage;

public class PageModifiedDateComparator
extends OrderByComparator<WikiPage> {
    public static final String ORDER_BY_ASC = "WikiPage.modifiedDate ASC";
    public static final String ORDER_BY_DESC = "WikiPage.modifiedDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modifiedDate"};
    private final boolean _ascending;

    public PageModifiedDateComparator() {
        this(false);
    }

    public PageModifiedDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(WikiPage page1, WikiPage page2) {
        int value = DateUtil.compareTo(page1.getModifiedDate(), page2.getModifiedDate());
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

