/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.processor;

import com.liferay.portal.kernel.util.StringParser;
import com.liferay.wiki.processor.WikiPageRenameContentProcessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BaseWikiPageRenameContentProcessor
implements WikiPageRenameContentProcessor {
    protected Map<String, String> regexps = new LinkedHashMap<String, String>();

    @Override
    public String processContent(long nodeId, String originalTitle, String newTitle, String originalContent) {
        return this.runRegexps(originalContent, originalTitle, newTitle);
    }

    protected String runRegexp(String content, String regexp, String replacement) {
        Pattern pattern = Pattern.compile(regexp, 8);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String runRegexps(String content, String title, String newTitle) {
        for (Map.Entry<String, String> entry : this.regexps.entrySet()) {
            String regexp = entry.getKey();
            String replacement = entry.getValue();
            regexp = regexp.replaceAll("@old_title@", Matcher.quoteReplacement(StringParser.escapeRegex(title)));
            replacement = replacement.replaceAll("@new_title@", Matcher.quoteReplacement(StringParser.escapeRegex(newTitle)));
            content = this.runRegexp(content, regexp, replacement);
        }
        return content;
    }
}

