/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml.descriptor;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.ElementIdentifier;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class SimpleXMLDescriptor
implements XMLDescriptor {
    @Override
    public boolean areEqual(Element el1, Element el2) {
        ElementIdentifier[] elIds;
        String name1 = el1.getName();
        String name2 = el2.getName();
        if (name1 == null || !name1.equals(name2)) {
            return false;
        }
        if (ArrayUtil.contains(this.getUniqueElements(), el1.getName())) {
            return true;
        }
        for (ElementIdentifier elId : elIds = this.getElementsIdentifiedByAttribute()) {
            if (!name1.equals(elId.getElementName())) continue;
            return this._compareAttribute(el1, el2, elId.getIdentifierName()) == 0;
        }
        for (ElementIdentifier elId : elIds = this.getElementsIdentifiedByChild()) {
            if (!name1.equals(elId.getElementName())) continue;
            return this._compareChildText(el1, el2, elId.getIdentifierName()) == 0;
        }
        ElementComparator comparator = new ElementComparator();
        return comparator.compare(el1, el2) == 0;
    }

    @Override
    public abstract boolean canHandleType(String var1, Document var2);

    @Override
    public boolean canJoinChildren(Element element) {
        return ArrayUtil.contains(this.getJoinableElements(), element.getName());
    }

    @Override
    public String[] getChildrenOrder(Element parentElement) {
        return new String[0];
    }

    public ElementIdentifier[] getElementsIdentifiedByAttribute() {
        return new ElementIdentifier[0];
    }

    public ElementIdentifier[] getElementsIdentifiedByChild() {
        return new ElementIdentifier[0];
    }

    public String[] getJoinableElements() {
        return new String[0];
    }

    @Override
    public String[] getRootChildrenOrder() {
        return new String[0];
    }

    public String[] getUniqueElements() {
        return new String[0];
    }

    private int _compareAttribute(Element el1, Element el2, String attrName) {
        String name1 = el1.attributeValue(attrName);
        String name2 = el2.attributeValue(attrName);
        if (name1 == null || name2 == null) {
            return -1;
        }
        return name1.compareTo(name2);
    }

    private int _compareChildText(Element el1, Element el2, String childName) {
        Element child1 = this._getChild(el1, childName);
        Element child2 = this._getChild(el2, childName);
        if (child1 == null || child2 == null) {
            return -1;
        }
        String name1 = child1.getText();
        String name2 = child2.getText();
        if (name1 == null || name2 == null) {
            return -1;
        }
        return name1.compareTo(name2);
    }

    private Element _getChild(Element parent, String childName) {
        Element child = parent.element(childName);
        return child;
    }
}

