/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.sl4fj;

import com.liferay.portal.kernel.log.Log;
import java.io.Serializable;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class LiferayLoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
Serializable {
    private final transient Log _log;

    public LiferayLoggerAdapter(Log log) {
        this._log = log;
        this._log.setLogWrapperClassName(LiferayLoggerAdapter.class.getName());
    }

    public LiferayLoggerAdapter(Log log, String name) {
        this(log);
        this.name = name;
    }

    @Override
    public void debug(String message) {
        this._log.debug(message);
    }

    @Override
    public void debug(String format, Object argument) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument);
            this._log.debug(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this._log.debug(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object argument1, Object argument2) {
        if (this.isDebugEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument1, argument2);
            this._log.debug(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        this._log.debug(message, t);
    }

    @Override
    public void error(String message) {
        this._log.error(message);
    }

    @Override
    public void error(String format, Object argument) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument);
            this._log.error(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this._log.error(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object argument1, Object argument2) {
        if (this.isErrorEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument1, argument2);
            this._log.error(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void error(String message, Throwable t) {
        this._log.error(message, t);
    }

    @Override
    public void info(String message) {
        this._log.info(message);
    }

    @Override
    public void info(String format, Object argument) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument);
            this._log.info(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this._log.info(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object argument1, Object argument2) {
        if (this.isInfoEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument1, argument2);
            this._log.info(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void info(String message, Throwable t) {
        this._log.info(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this._log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this._log.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this._log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this._log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this._log.isWarnEnabled();
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] arguments, Throwable t) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(message, arguments);
        if (level == 10) {
            this._log.debug(formattingTuple.getMessage(), t);
        } else if (level == 40) {
            this._log.error(formattingTuple.getMessage(), t);
        } else if (level == 0) {
            this._log.trace(formattingTuple.getMessage(), t);
        } else if (level == 30) {
            this._log.warn(formattingTuple.getMessage(), t);
        } else {
            this._log.info(formattingTuple.getMessage(), t);
        }
    }

    @Override
    public void trace(String message) {
        this._log.trace(message);
    }

    @Override
    public void trace(String format, Object argument) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument);
            this._log.trace(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this._log.trace(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object argument1, Object argument2) {
        if (this.isTraceEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument1, argument2);
            this._log.trace(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        this._log.trace(message, t);
    }

    @Override
    public void warn(String message) {
        this._log.warn(message);
    }

    @Override
    public void warn(String format, Object argument) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument);
            this._log.warn(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.arrayFormat(format, arguments);
            this._log.warn(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object argument1, Object argument2) {
        if (this.isWarnEnabled()) {
            FormattingTuple formattingTuple = MessageFormatter.format(format, argument1, argument2);
            this._log.warn(formattingTuple.getMessage(), formattingTuple.getThrowable());
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        this._log.warn(message, t);
    }
}

