/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionParameters {
    public static final String KEY = SessionParameters.class.getName();
    public static final boolean USE_SESSION_PARAMETERS = GetterUtil.getBoolean(SystemProperties.get(SessionParameters.class.getName()), true);

    public static String get(HttpServletRequest httpServletRequest, String parameter) {
        return SessionParameters.get(httpServletRequest.getSession(), parameter);
    }

    public static String get(HttpSession session, String parameter) {
        if (!USE_SESSION_PARAMETERS) {
            return parameter;
        }
        Map<String, String> parameters = SessionParameters._getParameters(session);
        String newParameter = parameters.get(parameter);
        if (newParameter == null) {
            newParameter = StringUtil.randomString() + "_" + parameter;
            parameters.put(parameter, newParameter);
        }
        return newParameter;
    }

    public static String get(PortletRequest portletRequest, String parameter) {
        return SessionParameters.get(portletRequest.getPortletSession(), parameter);
    }

    public static String get(PortletSession portletSession, String parameter) {
        if (!USE_SESSION_PARAMETERS) {
            return parameter;
        }
        Map<String, String> parameters = SessionParameters._getParameters(portletSession);
        String newParameter = parameters.get(parameter);
        if (newParameter == null) {
            newParameter = StringUtil.randomString() + "_" + parameter;
            parameters.put(parameter, newParameter);
        }
        return newParameter;
    }

    private static Map<String, String> _getParameters(HttpSession session) {
        HashMap<String, String> parameters = null;
        try {
            parameters = (HashMap<String, String>)session.getAttribute(KEY);
            if (parameters == null) {
                parameters = new HashMap();
                session.setAttribute(KEY, parameters);
            }
        }
        catch (IllegalStateException ise) {
            parameters = new HashMap<String, String>();
        }
        return parameters;
    }

    private static Map<String, String> _getParameters(PortletSession portletSession) {
        LinkedHashMap<String, String> parameters = null;
        try {
            parameters = (LinkedHashMap<String, String>)portletSession.getAttribute(KEY);
            if (parameters == null) {
                parameters = new LinkedHashMap();
                portletSession.setAttribute(KEY, parameters);
            }
        }
        catch (IllegalStateException ise) {
            parameters = new LinkedHashMap<String, String>();
        }
        return parameters;
    }
}

