/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.freemarker;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import java.io.IOException;
import java.io.Writer;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class FreeMarkerPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(FreeMarkerPortlet.class);

    @Override
    public void destroy() {
        super.destroy();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        TemplateManagerUtil.destroy(clazz.getClassLoader());
    }

    @Override
    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        PortletContext portletContext = this.getPortletContext();
        String servletContextName = portletContext.getPortletContextName();
        String resourcePath = servletContextName.concat("_SERVLET_CONTEXT_").concat(path);
        boolean resourceExists = false;
        try {
            resourceExists = TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath);
        }
        catch (TemplateException te) {
            throw new IOException(te);
        }
        if (!resourceExists) {
            _log.error(path + " is not a valid include");
        } else {
            try {
                TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource("ftl", resourcePath);
                TemplateManager templateManager = TemplateManagerUtil.getTemplateManager("ftl");
                Template template = TemplateManagerUtil.getTemplate("ftl", templateResource, false);
                templateManager.addTaglibSupport(template, PortalUtil.getHttpServletRequest(portletRequest), PortalUtil.getHttpServletResponse(portletResponse));
                template.put("portletContext", this.getPortletContext());
                template.put("userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
                template.prepare(PortalUtil.getHttpServletRequest(portletRequest));
                Writer writer = null;
                if (portletResponse instanceof MimeResponse) {
                    MimeResponse mimeResponse = (MimeResponse)portletResponse;
                    writer = UnsyncPrintWriterPool.borrow(mimeResponse.getWriter());
                } else {
                    writer = new UnsyncStringWriter();
                }
                template.processTemplate(writer);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", "true");
        }
    }
}

