/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.io.ProtectedObjectInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SerializableUtil {
    public static Object clone(Object object) {
        Class<?> clazz = object.getClass();
        return SerializableUtil.deserialize(SerializableUtil.serialize(object), clazz.getClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes) {
        try (ProtectedObjectInputStream objectInputStream = new ProtectedObjectInputStream(new UnsyncByteArrayInputStream(bytes));){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes, ClassLoader classLoader) {
        try (ProtectedClassLoaderObjectInputStream objectInputStream = new ProtectedClassLoaderObjectInputStream(new UnsyncByteArrayInputStream(bytes), classLoader);){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static byte[] serialize(Object object) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);){
            objectOutputStream.writeObject(object);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

