/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.ibm.icu.text.Transliterator;
import com.liferay.portal.kernel.util.StringUtil;

public class Normalizer {
    private static final char[] _NORMALIZED_TEXT = new char[]{'l', '\'', '\"'};
    private static final char[] _UNICODE_TEXT = new char[]{'\u0142', '\u02b9', '\u02ba'};

    public static String normalizeToAscii(String s) {
        if (!Normalizer._hasNonasciiCode(s)) {
            return s;
        }
        String normalizedText = TransliteratorHolder.transform(s);
        return StringUtil.replace(normalizedText, _UNICODE_TEXT, _NORMALIZED_TEXT);
    }

    private static boolean _hasNonasciiCode(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private static class TransliteratorHolder {
        private static final Transliterator _transliterator = Transliterator.getInstance((String)"Greek-Latin; Cyrillic-Latin; NFD; [:Nonspacing Mark:] Remove; NFC");

        private TransliteratorHolder() {
        }

        public static String transform(String s) {
            return _transliterator.transform(s);
        }
    }
}

