/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class InetAddressTask
extends Task {
    private String _hostAddressProperty;
    private String _hostNameProperty;
    private String _vmId1Property;
    private String _vmId2Property;

    public void execute() throws BuildException {
        try {
            int id;
            InetAddress inetAddress = InetAddress.getLocalHost();
            if (Validator.isNotNull(this._hostAddressProperty)) {
                this.getProject().setUserProperty(this._hostAddressProperty, inetAddress.getHostAddress());
            }
            if (Validator.isNotNull(this._hostNameProperty)) {
                this.getProject().setUserProperty(this._hostNameProperty, inetAddress.getHostName());
            }
            if (Validator.isNotNull(this._vmId1Property)) {
                id = GetterUtil.getInteger(StringUtil.extractDigits(inetAddress.getHostName()));
                this.getProject().setUserProperty(this._vmId1Property, String.valueOf(id * 2 - 1));
            }
            if (Validator.isNotNull(this._vmId2Property)) {
                id = GetterUtil.getInteger(StringUtil.extractDigits(inetAddress.getHostName()));
                this.getProject().setUserProperty(this._vmId2Property, String.valueOf(id * 2));
            }
        }
        catch (UnknownHostException uhe) {
            throw new BuildException((Throwable)uhe);
        }
    }

    public void setHostAddressProperty(String hostAddressProperty) {
        this._hostAddressProperty = hostAddressProperty;
    }

    public void setHostNameProperty(String hostNameProperty) {
        this._hostNameProperty = hostNameProperty;
    }

    public void setVmId1Property(String vmId1Property) {
        this._vmId1Property = vmId1Property;
    }

    public void setVmId2Property(String vmId2Property) {
        this._vmId2Property = vmId2Property;
    }
}

