/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.test.util.search;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CountryServiceUtil;
import com.liferay.portal.kernel.service.ListTypeServiceUtil;
import com.liferay.portal.kernel.service.RegionServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.OrganizationTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserGroupTestUtil;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.users.admin.test.util.search.DummyPermissionChecker;
import com.liferay.users.admin.test.util.search.GroupBlueprint;
import com.liferay.users.admin.test.util.search.OrganizationBlueprint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserSearchFixture {
    private final List<Address> _addresses = new ArrayList<Address>();
    private final List<AssetTag> _assetTags = new ArrayList<AssetTag>();
    private long _companyId;
    private final List<Group> _groups = new ArrayList<Group>();
    private final List<Organization> _organizations = new ArrayList<Organization>();
    private PermissionChecker _permissionChecker;
    private String _principal;
    private final List<UserGroup> _userGroups = new ArrayList<UserGroup>();
    private final List<User> _users = new ArrayList<User>();

    public Address addAddress(User user) throws PortalException {
        List<ListType> listTypes = ListTypeServiceUtil.getListTypes(ListTypeConstants.CONTACT_ADDRESS);
        ListType listType = listTypes.get(0);
        long listTypeId = listType.getListTypeId();
        long contactId = user.getContactId();
        Contact contact = user.getContact();
        String modelClassName = contact.getModelClassName();
        Country country = CountryServiceUtil.getCountryByName("united-states");
        long countryId = country.getCountryId();
        List<Region> regions = RegionServiceUtil.getRegions(countryId);
        Region region = regions.get(0);
        long regionId = region.getRegionId();
        Address address = AddressLocalServiceUtil.addAddress(user.getUserId(), modelClassName, contactId, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), regionId, countryId, listTypeId, false, false, new ServiceContext());
        this._addresses.add(address);
        return address;
    }

    public Group addGroup() throws Exception {
        Group group = GroupTestUtil.addGroup();
        this._groups.add(group);
        return group;
    }

    public Group addGroup(GroupBlueprint groupBlueprint) throws Exception {
        Group group = this.addGroup();
        Locale locale = groupBlueprint.getDefaultLocale();
        if (locale != null) {
            GroupTestUtil.updateDisplaySettings(group.getGroupId(), null, locale);
        }
        return group;
    }

    public Organization addOrganization() throws Exception {
        Organization organization = OrganizationTestUtil.addOrganization();
        this._organizations.add(organization);
        return organization;
    }

    public Organization addOrganization(OrganizationBlueprint organizationBlueprint) throws Exception {
        Organization organization = this.addOrganization();
        String[] assetTagNames = organizationBlueprint.getAssetTagNames();
        if (assetTagNames != null) {
            OrganizationTestUtil.updateAsset(organization, null, assetTagNames);
        }
        return organization;
    }

    public User addUser(String screenName, Group group, String ... assetTagNames) throws Exception {
        return this.addUser(screenName, RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), LocaleUtil.getDefault(), group, assetTagNames);
    }

    public User addUser(String screenName, String firstName, String lastName, Locale locale, Group group, String ... assetTagNames) throws Exception {
        ServiceContext serviceContext = UserSearchFixture.getServiceContext(group);
        serviceContext.setAssetTagNames(assetTagNames);
        User user = this._addUser(screenName, firstName, lastName, new long[]{group.getGroupId()}, locale, serviceContext);
        this._users.add(user);
        List<AssetTag> assetTags = AssetTagLocalServiceUtil.getTags(user.getModelClassName(), user.getPrimaryKey());
        this._assetTags.addAll(assetTags);
        return user;
    }

    public UserGroup addUserGroup() throws Exception {
        UserGroup userGroup = UserGroupTestUtil.addUserGroup();
        this._userGroups.add(userGroup);
        return userGroup;
    }

    public User addUserWithAddress(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        this.addAddress(user);
        UserLocalServiceUtil.updateUser(user);
        return user;
    }

    public User addUserWithJobTitle(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        user.setJobTitle(RandomTestUtil.randomString(new RandomizerBumper[0]));
        user = UserLocalServiceUtil.updateUser(user);
        return user;
    }

    public User addUserWithOrganization(String screenName, Group group, String ... assetTagNames) throws Exception {
        Organization organization = this.addOrganization();
        User user = this.addUser(screenName, group, assetTagNames);
        UserLocalServiceUtil.addOrganizationUser(organization.getOrganizationId(), user.getUserId());
        return user;
    }

    public User addUserWithUserGroup(String screenName, Group group, String ... assetTagNames) throws Exception {
        User user = this.addUser(screenName, group, assetTagNames);
        UserGroup userGroup = this.addUserGroup();
        UserGroupLocalServiceUtil.addUserUserGroup(user.getUserId(), userGroup);
        UserGroupLocalServiceUtil.addGroupUserGroup(group.getGroupId(), userGroup);
        return user;
    }

    public List<Address> getAddresses() {
        return this._addresses;
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public List<Organization> getOrganizations() {
        return this._organizations;
    }

    public SearchContext getSearchContext(String keywords) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(TestPropsValues.getCompanyId());
        searchContext.setKeywords(keywords);
        searchContext.setUserId(TestPropsValues.getUserId());
        return searchContext;
    }

    public List<UserGroup> getUserGroups() {
        return this._userGroups;
    }

    public List<User> getUsers() {
        return this._users;
    }

    public void setUp() throws Exception {
        this._companyId = TestPropsValues.getCompanyId();
        this._permissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker(new DummyPermissionChecker(){

            @Override
            public long getCompanyId() {
                return UserSearchFixture.this._companyId;
            }

            @Override
            public boolean hasPermission(Group group, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(Group group, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
                return true;
            }

            @Override
            public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
                return true;
            }

            @Override
            public boolean isCompanyAdmin(long companyId) {
                return true;
            }
        });
        this._principal = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName(TestPropsValues.getUserId());
    }

    public void tearDown() {
        PermissionThreadLocal.setPermissionChecker(this._permissionChecker);
        PrincipalThreadLocal.setName(this._principal);
    }

    public Map<String, String> toMap(List<Document> list) {
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Document document : list) {
            Object[] values = document.getValues("assetTagNames");
            Arrays.sort(values);
            map.put(document.get("screenName"), StringUtil.merge(values));
        }
        return map;
    }

    public Map<String, String> toMap(User user, String ... tags) {
        return Collections.singletonMap(user.getScreenName(), this.toStringTags(tags));
    }

    public String toStringTags(String[] tags) {
        ArrayList<String> list = new ArrayList<String>(tags.length);
        for (String tag : tags) {
            list.add(StringUtil.toLowerCase(tag));
        }
        Collections.sort(list);
        return StringUtil.merge(list);
    }

    protected static ServiceContext getServiceContext(Group group) throws Exception {
        return ServiceContextTestUtil.getServiceContext(group.getGroupId(), TestPropsValues.getUserId());
    }

    private User _addUser(String screenName, String firstName, String lastName, long[] groupIds, Locale locale, ServiceContext serviceContext) throws Exception {
        return UserTestUtil.addUser(this._companyId, TestPropsValues.getUserId(), screenName, locale, firstName, lastName, groupIds, serviceContext);
    }
}

