/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.test.util.WhenHasStatusByUserIdField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUADExporterTestCase<T extends BaseModel> {
    protected UADExporter<T> uadExporter;
    @DeleteAfterTestRun
    protected User user;

    @Before
    public void setUp() throws Exception {
        this.uadExporter = this.getUADExporter();
        this.user = UserTestUtil.addUser();
    }

    @Test
    public void testExport() throws Exception {
        T baseModel = this.addBaseModel(this.user.getUserId());
        Document document = this.getExportDocument(baseModel);
        this.assertColumnValue(document, "userId", String.valueOf(this.user.getUserId()));
        this.assertColumnValue(document, this.getPrimaryKeyName(), String.valueOf(baseModel.getPrimaryKeyObj()));
    }

    @Test
    public void testExportAll() throws Exception {
        this.addBaseModel(this.user.getUserId());
        File file = this.uadExporter.exportAll(this.user.getUserId());
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader(file);
        List<String> entries = zipReader.getEntries();
        Assert.assertEquals(entries.toString(), 1L, entries.size());
    }

    @Test
    public void testExportByStatusByUserId() throws Exception {
        Assume.assumeTrue(this instanceof WhenHasStatusByUserIdField);
        WhenHasStatusByUserIdField whenHasStatusByUserIdField = (WhenHasStatusByUserIdField)((Object)this);
        BaseModel baseModel = (BaseModel)whenHasStatusByUserIdField.addBaseModelWithStatusByUserId(TestPropsValues.getUserId(), this.user.getUserId());
        Document document = this.getExportDocument(baseModel);
        this.assertColumnValue(document, "statusByUserId", String.valueOf(this.user.getUserId()));
        this.assertColumnValue(document, this.getPrimaryKeyName(), String.valueOf(baseModel.getPrimaryKeyObj()));
    }

    protected abstract T addBaseModel(long var1) throws Exception;

    protected void assertColumnValue(Document document, String columnName, String expectedColumnValue) {
        String nodeSelector = "/model/column[column-name='" + columnName + "']/column-value";
        Node columnNode = document.selectSingleNode(nodeSelector);
        Assert.assertEquals(expectedColumnValue, columnNode.getText());
    }

    protected Document getExportDocument(T baseModel) throws Exception {
        byte[] bytes = this.uadExporter.export(baseModel);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        return SAXReaderUtil.read(byteArrayInputStream);
    }

    protected abstract String getPrimaryKeyName();

    protected abstract UADExporter<T> getUADExporter();
}

