/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.test.util.WhenHasStatusByUserIdField;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUADDisplayTestCase<T> {
    private UADDisplay<T> _uadDisplay;
    @DeleteAfterTestRun
    private User _user;

    @Before
    public void setUp() throws Exception {
        this._uadDisplay = this.getUADDisplay();
        this._user = UserTestUtil.addUser();
    }

    @Test
    public void testCount() throws Exception {
        this.addBaseModel(this._user.getUserId());
        Assert.assertEquals(1L, this._uadDisplay.count(this._user.getUserId()));
    }

    @Test
    public void testGetAllByStatusByUserId() throws Exception {
        Assume.assumeTrue(this instanceof WhenHasStatusByUserIdField);
        WhenHasStatusByUserIdField whenHasStatusByUserIdField = (WhenHasStatusByUserIdField)((Object)this);
        Object baseModel = whenHasStatusByUserIdField.addBaseModelWithStatusByUserId(TestPropsValues.getUserId(), this._user.getUserId());
        List<T> baseModels = this._uadDisplay.getRange(this._user.getUserId(), -1, -1);
        Assert.assertEquals(baseModels.toString(), 1L, baseModels.size());
        Assert.assertEquals(baseModel, baseModels.get(0));
    }

    @Test
    public void testGetAllWithNoBaseModel() throws Exception {
        Assert.assertEquals(0L, this._uadDisplay.count(this._user.getUserId()));
    }

    @Test
    public void testGetTypeName() {
        Assert.assertTrue("The type name should not be null", Validator.isNotNull(this._uadDisplay.getTypeName(LocaleUtil.US)));
    }

    protected abstract BaseModel<?> addBaseModel(long var1) throws Exception;

    protected abstract UADDisplay<T> getUADDisplay();
}

