/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.test.util;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.user.associated.data.anonymizer.UADAnonymizer;
import com.liferay.user.associated.data.test.util.WhenHasStatusByUserIdField;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUADAnonymizerTestCase<T extends BaseModel> {
    @DeleteAfterTestRun
    protected User anonymousUser;
    protected UADAnonymizer<T> uadAnonymizer;
    @DeleteAfterTestRun
    protected User user;

    @Before
    public void setUp() throws Exception {
        this.anonymousUser = UserTestUtil.addUser();
        this.uadAnonymizer = this.getUADAnonymizer();
        this.user = UserTestUtil.addUser();
    }

    @Test
    public void testAutoAnonymize() throws Exception {
        T baseModel = this.addBaseModel(this.user.getUserId());
        this.testAutoAnonymize(baseModel);
    }

    @Test
    public void testAutoAnonymizeAll() throws Exception {
        T baseModel = this.addBaseModel(TestPropsValues.getUserId());
        T autoAnonymizedBaseModel = this.addBaseModel(this.user.getUserId());
        this.uadAnonymizer.autoAnonymizeAll(this.user.getUserId(), this.anonymousUser);
        long baseModelPK = this.getBaseModelPrimaryKey((BaseModel)baseModel);
        Assert.assertFalse(this.isBaseModelAutoAnonymized(baseModelPK, TestPropsValues.getUser()));
        long autoAnonymizedBaseModelPK = this.getBaseModelPrimaryKey((BaseModel)autoAnonymizedBaseModel);
        Assert.assertTrue(this.isBaseModelAutoAnonymized(autoAnonymizedBaseModelPK, this.user));
    }

    @Test
    public void testAutoAnonymizeAllWithNoBaseModel() throws Exception {
        this.uadAnonymizer.autoAnonymizeAll(this.user.getUserId(), this.anonymousUser);
    }

    @Test
    public void testAutoAnonymizeStatusByUserOnly() throws Exception {
        Assume.assumeTrue(this instanceof WhenHasStatusByUserIdField);
        WhenHasStatusByUserIdField whenHasStatusByUserIdField = (WhenHasStatusByUserIdField)((Object)this);
        BaseModel baseModel = (BaseModel)whenHasStatusByUserIdField.addBaseModelWithStatusByUserId(TestPropsValues.getUserId(), this.user.getUserId());
        this.testAutoAnonymize(baseModel);
    }

    @Test
    public void testAutoAnonymizeUserOnly() throws Exception {
        Assume.assumeTrue(this instanceof WhenHasStatusByUserIdField);
        WhenHasStatusByUserIdField whenHasStatusByUserIdField = (WhenHasStatusByUserIdField)((Object)this);
        BaseModel baseModel = (BaseModel)whenHasStatusByUserIdField.addBaseModelWithStatusByUserId(this.user.getUserId(), TestPropsValues.getUserId());
        this.testAutoAnonymize(baseModel);
    }

    @Test
    public void testDelete() throws Exception {
        T baseModel = this.addBaseModel(this.user.getUserId(), false);
        this.uadAnonymizer.delete(baseModel);
        this.deleteBaseModels(Arrays.asList(baseModel));
        long baseModelPK = this.getBaseModelPrimaryKey((BaseModel)baseModel);
        Assert.assertTrue(this.isBaseModelDeleted(baseModelPK));
    }

    @Test
    public void testDeleteAll() throws Exception {
        T baseModel = this.addBaseModel(TestPropsValues.getUserId());
        T deletedBaseModel = this.addBaseModel(this.user.getUserId(), false);
        this.uadAnonymizer.deleteAll(this.user.getUserId());
        this.deleteBaseModels(ListUtil.toList(deletedBaseModel));
        long baseModelPK = this.getBaseModelPrimaryKey((BaseModel)baseModel);
        Assert.assertFalse(this.isBaseModelDeleted(baseModelPK));
        long deletedBaseModelPK = this.getBaseModelPrimaryKey((BaseModel)deletedBaseModel);
        Assert.assertTrue(this.isBaseModelDeleted(deletedBaseModelPK));
    }

    @Test
    public void testDeleteAllWithNoBaseModel() throws Exception {
        this.uadAnonymizer.deleteAll(this.user.getUserId());
    }

    protected abstract T addBaseModel(long var1) throws Exception;

    protected abstract T addBaseModel(long var1, boolean var3) throws Exception;

    protected void deleteBaseModels(List<T> baseModels) throws Exception {
    }

    protected long getBaseModelPrimaryKey(BaseModel baseModel) {
        return (Long)baseModel.getPrimaryKeyObj();
    }

    protected abstract UADAnonymizer<T> getUADAnonymizer();

    protected abstract boolean isBaseModelAutoAnonymized(long var1, User var3) throws Exception;

    protected abstract boolean isBaseModelDeleted(long var1);

    protected void testAutoAnonymize(T baseModel) throws Exception {
        long userId = this.user.getUserId();
        Assert.assertEquals(1L, this.uadAnonymizer.count(userId));
        this.uadAnonymizer.autoAnonymize((BaseModel)baseModel.clone(), this.user.getUserId(), this.anonymousUser);
        long baseModelPK = this.getBaseModelPrimaryKey((BaseModel)baseModel);
        Assert.assertEquals(0L, this.uadAnonymizer.count(userId));
        Assert.assertTrue(this.isBaseModelAutoAnonymized(baseModelPK, this.user));
    }
}

