/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.display;

import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Order;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.user.associated.data.display.UADDisplay;
import com.liferay.user.associated.data.util.UADDynamicQueryUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BaseModelUADDisplay<T extends BaseModel>
implements UADDisplay<T> {
    private static final Log _log = LogFactoryUtil.getLog(BaseModelUADDisplay.class);

    @Override
    public long count(long userId) {
        return this.doCount(this.getDynamicQuery(userId));
    }

    @Override
    public Map<String, Object> getFieldValues(T t, String[] fieldNames, Locale locale) {
        Map<String, Object> modelAttributes = t.getModelAttributes();
        Set<String> modelAttributesKeySet = modelAttributes.keySet();
        modelAttributesKeySet.retainAll(Arrays.asList(fieldNames));
        return modelAttributes;
    }

    @Override
    public Serializable getPrimaryKey(T baseModel) {
        return baseModel.getPrimaryKeyObj();
    }

    @Override
    public List<T> getRange(long userId, int start, int end) {
        return this.doGetRange(this.getDynamicQuery(userId), start, end);
    }

    @Override
    public String[] getSortingFieldNames() {
        return ArrayUtil.append(new String[]{"createDate", "modifiedDate"}, this.getColumnFieldNames());
    }

    @Override
    public String getTypeName(Locale locale) {
        return this.getTypeClass().getSimpleName();
    }

    @Override
    public boolean isSiteScoped() {
        return GroupedModel.class.isAssignableFrom(this.getTypeClass());
    }

    @Override
    public List<T> search(long userId, long[] groupIds, String keywords, String orderByField, String orderByType, int start, int end) {
        return this.doGetRange(this.getSearchDynamicQuery(userId, groupIds, keywords, orderByField, orderByType), start, end);
    }

    @Override
    public long searchCount(long userId, long[] groupIds, String keywords) {
        return this.doCount(this.getSearchDynamicQuery(userId, groupIds, keywords, null, null));
    }

    protected abstract long doCount(DynamicQuery var1);

    protected abstract DynamicQuery doGetDynamicQuery();

    protected abstract List<T> doGetRange(DynamicQuery var1, int var2, int var3);

    protected abstract String[] doGetUserIdFieldNames();

    protected DynamicQuery getDynamicQuery(long userId) {
        return UADDynamicQueryUtil.addDynamicQueryCriteria(this.doGetDynamicQuery(), this.doGetUserIdFieldNames(), userId);
    }

    protected OrderByComparator<T> getOrderByComparator(String orderByField, String orderByType) {
        return null;
    }

    protected String[] getSearchableFields() {
        return this.getDisplayFieldNames();
    }

    protected DynamicQuery getSearchDynamicQuery(long userId, long[] groupIds, String keywords, String orderByField, String orderByType) {
        DynamicQuery dynamicQuery = this.getDynamicQuery(userId);
        if (this.isSiteScoped() && ArrayUtil.isNotEmpty(groupIds)) {
            dynamicQuery.add(RestrictionsFactoryUtil.in("groupId", ArrayUtil.toLongArray(groupIds)));
        }
        String[] searchableFields = this.getSearchableFields();
        if (Validator.isNotNull(keywords) && searchableFields.length > 0) {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            String quotedKeywords = StringUtil.quote(keywords, '%');
            Class clazz = this.getTypeClass();
            for (String searchableField : searchableFields) {
                try {
                    Method method = clazz.getMethod("get" + TextFormatter.format(searchableField, 6), new Class[0]);
                    if (method.getReturnType() != String.class) continue;
                    disjunction.add(RestrictionsFactoryUtil.ilike(searchableField, quotedKeywords));
                }
                catch (NoSuchMethodException | SecurityException e) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug(e, e);
                }
            }
            dynamicQuery.add(disjunction);
        }
        if (orderByField != null) {
            OrderByComparator<T> obc = this.getOrderByComparator(orderByField, orderByType);
            if (obc != null) {
                OrderFactoryUtil.addOrderByComparator(dynamicQuery, obc);
            } else {
                Order order = null;
                order = Objects.equals(orderByType, "desc") ? OrderFactoryUtil.desc(orderByField) : OrderFactoryUtil.asc(orderByField);
                dynamicQuery.addOrder(order);
            }
        }
        return dynamicQuery;
    }
}

