/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.taglib.servlet.taglib;

import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.taglib.internal.servlet.ServletContextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class UndoTag
extends IncludeTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;
    private static final String _PAGE = "/undo/page.jsp";
    private String _portletURL;
    private String _redirect;

    @Override
    public int doStartTag() {
        return 1;
    }

    public String getPortletURL() {
        return this._portletURL;
    }

    public String getRedirect() {
        return this._redirect;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.servletContext = ServletContextUtil.getServletContext();
    }

    public void setPortletURL(PortletURL portletURL) {
        this._portletURL = portletURL.toString();
    }

    public void setPortletURL(String portletURL) {
        this._portletURL = portletURL;
    }

    public void setRedirect(String redirect) {
        this._redirect = redirect;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._portletURL = null;
        this._redirect = null;
    }

    @Override
    protected String getPage() {
        if (ListUtil.isEmpty(this._getTrashedModels())) {
            return null;
        }
        return _PAGE;
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List<TrashedModel> trashedModels = this._getTrashedModels();
        ArrayList<Long> restoreTrashEntryIds = new ArrayList<Long>();
        ArrayList<String> titles = new ArrayList<String>();
        for (TrashedModel trashedModel : trashedModels) {
            try {
                TrashEntry trashEntry = trashedModel.getTrashEntry();
                TrashHandler trashHandler = trashedModel.getTrashHandler();
                TrashRenderer trashRenderer = trashHandler.getTrashRenderer(trashedModel.getTrashEntryClassPK());
                restoreTrashEntryIds.add(trashEntry.getEntryId());
                titles.add(trashRenderer.getTitle(themeDisplay.getLocale()));
            }
            catch (Exception exception) {}
        }
        httpServletRequest.setAttribute("liferay-trash:undo:cmd", (Object)this._getCmd());
        httpServletRequest.setAttribute("liferay-trash:undo:portletURL", (Object)this._portletURL);
        httpServletRequest.setAttribute("liferay-trash:undo:redirect", (Object)this._redirect);
        httpServletRequest.setAttribute("liferay-trash:undo:restoreTrashEntryIds", restoreTrashEntryIds);
        httpServletRequest.setAttribute("liferay-trash:undo:titles", titles);
        httpServletRequest.setAttribute("liferay-trash:undo:trashedEntriesCount", (Object)restoreTrashEntryIds.size());
    }

    private String _getCmd() {
        Map<String, Object> data = this._getData();
        if (data == null) {
            return "move_to_trash";
        }
        return MapUtil.getString(data, "cmd");
    }

    private Map<String, Object> _getData() {
        PortletDisplay portletDisplay;
        String key;
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (!SessionMessages.contains(portletRequest, key = (portletDisplay = themeDisplay.getPortletDisplay()).getId() + ".deleteSuccessData")) {
            return null;
        }
        return (HashMap)SessionMessages.get(portletRequest, key);
    }

    private List<TrashedModel> _getTrashedModels() {
        Map<String, Object> data = this._getData();
        if (data == null) {
            return Collections.emptyList();
        }
        List trashedModels = (List)data.get("trashedModels");
        if (ListUtil.isEmpty(trashedModels)) {
            return Collections.emptyList();
        }
        return trashedModels;
    }
}

