/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.text.localizer.taglib.internal.address;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.text.localizer.address.AddressTextLocalizer;
import com.liferay.text.localizer.taglib.internal.address.util.AddressUtil;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"country=US"}, service={AddressTextLocalizer.class})
public class USAddressTextLocalizer
implements AddressTextLocalizer {
    @Reference
    protected Html html;

    @Override
    public String format(Address address) {
        String street3;
        String street2;
        StringBundler sb = new StringBundler(13);
        Address escapedAddress = (Address)address.toEscapedModel();
        String street1 = escapedAddress.getStreet1();
        if (Validator.isNotNull(street1)) {
            sb.append(street1);
        }
        if (Validator.isNotNull(street2 = escapedAddress.getStreet2())) {
            sb.append("\n");
            sb.append(street2);
        }
        if (Validator.isNotNull(street3 = escapedAddress.getStreet3())) {
            sb.append("\n");
            sb.append(street3);
        }
        String city = escapedAddress.getCity();
        boolean hasCity = Validator.isNotNull(city);
        Optional<String> regionNameOptional = AddressUtil.getRegionNameOptional(address);
        boolean hasRegionName = regionNameOptional.isPresent();
        String zip = escapedAddress.getZip();
        boolean hasZip = Validator.isNotNull(zip);
        if (hasCity || hasRegionName || hasZip) {
            sb.append("\n");
        }
        if (hasCity) {
            sb.append(city);
            if (hasRegionName || hasZip) {
                sb.append(", ");
            }
        }
        regionNameOptional.ifPresent(regionName -> sb.append(this.html.escape((String)regionName)));
        if (hasZip) {
            if (hasRegionName) {
                sb.append(" ");
            }
            sb.append(zip);
        }
        Optional<String> countryNameOptional = AddressUtil.getCountryNameOptional(address);
        countryNameOptional.ifPresent(countryName -> {
            sb.append("\n");
            sb.append(this.html.escape((String)countryName));
        });
        String s = sb.toString();
        return s.trim();
    }
}

