/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemeUtil {
    private static final Log _log = LogFactoryUtil.getLog(ThemeUtil.class);
    private static final ServiceTrackerList<TemplateContextContributor> _templateContextContributors = ServiceTrackerCollections.openList(TemplateContextContributor.class, "(type=THEME)");

    public static String getPortletId(HttpServletRequest httpServletRequest) {
        String portletId = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletId = portletDisplay.getId();
        }
        return portletId;
    }

    public static void include(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme) throws Exception {
        ThemeUtil.include(servletContext, httpServletRequest, httpServletResponse, path, theme, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String include(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean write) throws Exception {
        String pluginServletContextName = GetterUtil.getString(theme.getServletContextName());
        ServletContext pluginServletContext = ServletContextPool.get(pluginServletContextName);
        ClassLoader pluginClassLoader = null;
        if (pluginServletContext != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
            currentThread.setContextClassLoader(pluginClassLoader);
        }
        try {
            String string = ThemeUtil.doIncludeFTL(servletContext, httpServletRequest, httpServletResponse, path, theme, false, write);
            return string;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    @Deprecated
    public static String includeFTL(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.include(servletContext, httpServletRequest, httpServletResponse, path, theme, write);
    }

    @Deprecated
    public static void includeJSP(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme) throws Exception {
        ThemeUtil.doDispatch(servletContext, httpServletRequest, httpServletResponse, path, theme, true, "jsp");
    }

    @Deprecated
    public static String includeVM(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.doDispatch(servletContext, httpServletRequest, httpServletResponse, path, theme, write, "vm");
    }

    @Deprecated
    protected static String doDispatch(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean write, String extension) throws Exception {
        return ThemeUtil.include(servletContext, httpServletRequest, httpServletResponse, path, theme, write);
    }

    protected static String doIncludeFTL(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString(theme.getServletContextName());
        if (ServletContextPool.get(servletContextName) == null) {
            ServletContextPool.put(servletContextName, servletContext);
        }
        String portletId = ThemeUtil.getPortletId(httpServletRequest);
        String resourcePath = theme.getResourcePath(servletContext, portletId, path);
        if (Validator.isNotNull(portletId) && PortletIdCodec.hasInstanceId(portletId) && !TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            resourcePath = theme.getResourcePath(servletContext, rootPortletId, path);
        }
        if (Validator.isNotNull(portletId) && !TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            resourcePath = theme.getResourcePath(servletContext, null, path);
        }
        if (!TemplateResourceLoaderUtil.hasTemplateResource("ftl", resourcePath)) {
            _log.error(resourcePath + " does not exist");
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource("ftl", resourcePath);
        Template template = TemplateManagerUtil.getTemplate("ftl", templateResource, restricted);
        template.prepare(httpServletRequest);
        for (TemplateContextContributor templateContextContributor : _templateContextContributors) {
            templateContextContributor.prepare(template, httpServletRequest);
        }
        ServletContext themeServletContext = ServletContextPool.get(servletContextName);
        template.put("themeServletContext", themeServletContext);
        Writer writer = null;
        if (write) {
            writer = httpServletResponse.getWriter();
        } else {
            writer = new UnsyncStringWriter();
            httpServletResponse = new PipingServletResponse((HttpServletResponse)httpServletResponse, writer);
        }
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager("ftl");
        templateManager.addTaglibSupport(template, httpServletRequest, (HttpServletResponse)httpServletResponse);
        templateManager.addTaglibTheme(template, "taglibLiferay", httpServletRequest, (HttpServletResponse)httpServletResponse);
        template.put("writer", writer);
        template.processTemplate(writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }

    @Deprecated
    protected static void doIncludeJSP(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, Theme theme) throws Exception {
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            if (themeServletContext == null) {
                _log.error(StringBundler.concat("Theme ", theme.getThemeId(), " cannot find its ", "servlet context at ", theme.getServletContextName()));
            } else {
                RequestDispatcher requestDispatcher = themeServletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    _log.error(StringBundler.concat("Theme ", theme.getThemeId(), " does not have ", path));
                } else {
                    requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
            }
        } else {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                _log.error(StringBundler.concat("Theme ", theme.getThemeId(), " does not have ", path));
            } else {
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
    }

    @Deprecated
    protected static String doIncludeVM(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String page, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString(theme.getServletContextName());
        if (ServletContextPool.get(servletContextName) == null) {
            ServletContextPool.put(servletContextName, servletContext);
        }
        String portletId = ThemeUtil.getPortletId(httpServletRequest);
        String resourcePath = theme.getResourcePath(servletContext, portletId, page);
        boolean checkResourceExists = true;
        if (Validator.isNotNull(portletId)) {
            if (PortletIdCodec.hasInstanceId(portletId) && checkResourceExists != TemplateResourceLoaderUtil.hasTemplateResource("vm", resourcePath)) {
                String rootPortletId = PortletIdCodec.decodePortletName(portletId);
                resourcePath = theme.getResourcePath(servletContext, rootPortletId, page);
            }
            if (checkResourceExists && checkResourceExists != TemplateResourceLoaderUtil.hasTemplateResource("vm", resourcePath)) {
                resourcePath = theme.getResourcePath(servletContext, null, page);
            }
        }
        if (checkResourceExists && !TemplateResourceLoaderUtil.hasTemplateResource("vm", resourcePath)) {
            _log.error(resourcePath + " does not exist");
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource("vm", resourcePath);
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + resourcePath);
        }
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager("vm");
        Template template = TemplateManagerUtil.getTemplate("vm", templateResource, restricted);
        template.prepare(httpServletRequest);
        for (TemplateContextContributor templateContextContributor : _templateContextContributors) {
            templateContextContributor.prepare(template, httpServletRequest);
        }
        ServletContext themeServletContext = ServletContextPool.get(servletContextName);
        template.put("themeServletContext", themeServletContext);
        Writer writer = null;
        if (write) {
            writer = httpServletResponse.getWriter();
        } else {
            writer = new UnsyncStringWriter();
            httpServletResponse = new PipingServletResponse((HttpServletResponse)httpServletResponse, writer);
        }
        templateManager.addTaglibTheme(template, "taglibLiferay", httpServletRequest, (HttpServletResponse)httpServletResponse);
        template.put("writer", writer);
        template.processTemplate(writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }
}

