/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class TagResourceBundleUtil {
    private static final ResourceBundle _emptyResourceBundle = new EmptyResourceBundle();

    public static ResourceBundle getResourceBundle(HttpServletRequest httpServletRequest, Locale locale) {
        ResourceBundleLoader resourceBundleLoader = TagResourceBundleUtil.getResourceBundleLoader(httpServletRequest);
        if (resourceBundleLoader != null) {
            return resourceBundleLoader.loadResourceBundle(locale);
        }
        ResourceBundle portletResourceBundle = TagResourceBundleUtil.getPortletResourceBundle(httpServletRequest, locale);
        ResourceBundle portalResourceBundle = PortalUtil.getResourceBundle(locale);
        return new AggregateResourceBundle(portletResourceBundle, portalResourceBundle);
    }

    public static ResourceBundle getResourceBundle(PageContext pageContext) {
        ResourceBundle resourceBundle = (ResourceBundle)pageContext.getAttribute("resourceBundle");
        HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        Locale locale = PortalUtil.getLocale(httpServletRequest);
        if (resourceBundle != null) {
            return new AggregateResourceBundle(resourceBundle, PortalUtil.getResourceBundle(locale));
        }
        return TagResourceBundleUtil.getResourceBundle(httpServletRequest, locale);
    }

    protected static ResourceBundle getPortletResourceBundle(HttpServletRequest httpServletRequest, Locale locale) {
        PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        if (portletConfig != null) {
            return portletConfig.getResourceBundle(locale);
        }
        return _emptyResourceBundle;
    }

    protected static ResourceBundleLoader getResourceBundleLoader(HttpServletRequest httpServletRequest) {
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)httpServletRequest.getAttribute("RESOURCE_BUNDLE_LOADER");
        if (resourceBundleLoader == null) {
            LiferayPortletContext liferayPortletContext;
            ServletContext portletServletContext;
            String portletServletContextName;
            ServletContext servletContext = httpServletRequest.getServletContext();
            String servletContextName = servletContext.getServletContextName();
            if (Validator.isNull(servletContextName)) {
                return null;
            }
            resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName(servletContextName);
            PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
            if (portletConfig != null && servletContextName.equals(portletServletContextName = (portletServletContext = (liferayPortletContext = (LiferayPortletContext)portletConfig.getPortletContext()).getServletContext()).getServletContextName())) {
                resourceBundleLoader = locale -> portletConfig.getResourceBundle(locale);
            }
        }
        if (resourceBundleLoader == null) {
            return null;
        }
        return new AggregateResourceBundleLoader(resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader());
    }

    private static class EmptyResourceBundle
    extends ResourceBundle {
        private EmptyResourceBundle() {
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }
}

