/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.BaseBodyTagSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.BodyTag;

public class PositionTagSupport
extends BaseBodyTagSupport
implements BodyTag {
    private static final String _POSITION_AUTO = "auto";
    private static final String _POSITION_INLINE = "inline";
    private String _position;

    public String getPosition() {
        return this.getPositionValue();
    }

    public boolean isPositionAuto() {
        String position = this.getPosition();
        return position.equals(_POSITION_AUTO);
    }

    public boolean isPositionInLine() {
        String position = this.getPosition();
        return position.equals(_POSITION_INLINE);
    }

    public void setPosition(String position) {
        this._position = position;
    }

    protected void cleanUp() {
        this._position = null;
    }

    protected String getPositionValue() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        String position = this._position;
        String fragmentId = ParamUtil.getString(httpServletRequest, "p_f_id");
        if (Validator.isNotNull(fragmentId)) {
            position = _POSITION_INLINE;
        }
        if (Validator.isNull(position)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            position = themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() ? _POSITION_INLINE : _POSITION_AUTO;
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            String portletId = portletDisplay.getId();
            if (Validator.isNotNull(portletId) && themeDisplay.isPortletEmbedded(themeDisplay.getScopeGroupId(), themeDisplay.getLayout(), portletId)) {
                position = _POSITION_INLINE;
            }
        }
        return position;
    }
}

