/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.BaseBodyTagSupport;
import com.liferay.taglib.util.ParamAncestorTag;
import com.liferay.taglib.util.PropertyAncestorTag;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class ParamAndPropertyAncestorTagImpl
extends BaseBodyTagSupport
implements ParamAncestorTag,
PropertyAncestorTag {
    protected HttpServletRequest request;
    protected ServletContext servletContext;
    private boolean _allowEmptyParam;
    private boolean _copyCurrentRenderParameters = true;
    private DynamicServletRequest _dynamicServletRequest;
    private Map<String, String[]> _properties;
    private Set<String> _removedParameterNames;

    @Override
    public void addParam(String name, String value) {
        if (Validator.isNull(name)) {
            throw new IllegalArgumentException();
        }
        if (this._dynamicServletRequest == null) {
            this._dynamicServletRequest = new DynamicServletRequest(this.request);
            this.request = this._dynamicServletRequest;
        }
        Map<String, String[]> params = this._dynamicServletRequest.getDynamicParameterMap();
        if (!(this._allowEmptyParam || value != null && value.length() != 0)) {
            params.remove(name);
            if (this._removedParameterNames == null) {
                this._removedParameterNames = new HashSet<String>();
            }
            this._removedParameterNames.add(name);
            return;
        }
        String[] values = params.get(name);
        if (!this._copyCurrentRenderParameters || values == null) {
            values = new String[]{value};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            values = newValues;
        }
        params.put(name, values);
    }

    @Override
    public void addProperty(String name, String value) {
        if (this._properties == null) {
            this._properties = new LinkedHashMap<String, String[]>();
        }
        String[] values = this._properties.get(name);
        if (!this._copyCurrentRenderParameters || values == null) {
            values = new String[]{value};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            values = newValues;
        }
        this._properties.put(name, values);
    }

    public void clearParams() {
        if (this._dynamicServletRequest != null) {
            Map<String, String[]> params = this._dynamicServletRequest.getDynamicParameterMap();
            params.clear();
            this.request = (HttpServletRequest)this._dynamicServletRequest.getRequest();
            this._dynamicServletRequest = null;
        }
        if (this._removedParameterNames != null) {
            this._removedParameterNames.clear();
        }
    }

    public void clearProperties() {
        if (this._properties != null) {
            this._properties.clear();
        }
    }

    public Map<String, String[]> getParams() {
        if (this._dynamicServletRequest != null) {
            return this._dynamicServletRequest.getDynamicParameterMap();
        }
        return null;
    }

    public Map<String, String[]> getProperties() {
        return this._properties;
    }

    public Set<String> getRemovedParameterNames() {
        return this._removedParameterNames;
    }

    public boolean isAllowEmptyParam() {
        return this._allowEmptyParam;
    }

    @Override
    public void release() {
        super.release();
        this.request = null;
        this.servletContext = null;
        this._allowEmptyParam = false;
        this._copyCurrentRenderParameters = true;
        this._properties = null;
        this._removedParameterNames = null;
    }

    public void setAllowEmptyParam(boolean allowEmptyParam) {
        this._allowEmptyParam = allowEmptyParam;
    }

    public void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this._copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.request = (HttpServletRequest)pageContext.getRequest();
        this.servletContext = (ServletContext)this.request.getAttribute("CTX");
        if (this.servletContext == null) {
            this.servletContext = pageContext.getServletContext();
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

