/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIdFactory;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIdFactoryRegistry;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIncludeUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CustomJspRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.AttributesTagSupport;
import com.liferay.taglib.util.ThemeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;

public class IncludeTag
extends AttributesTagSupport {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = false;
    private static final boolean _THEME_JSP_OVERRIDE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("theme.jsp.override.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(IncludeTag.class);
    private String _page;
    private Set<String> _setAttributeNames;
    private boolean _strict;
    private TrackedServletRequest _trackedRequest;
    private boolean _useCustomPage = true;

    @Override
    public int doEndTag() throws JspException {
        try {
            String page = this.getPage();
            if (Validator.isNull(page)) {
                page = this.getEndPage();
            }
            this.callSetAttributes();
            if (this.themeResourceExists(page)) {
                this.doIncludeTheme(page);
                int n = 6;
                return n;
            }
            if (!FileAvailabilityUtil.isAvailable(this.servletContext, page)) {
                this.logUnavailablePage(page);
                int n = this.processEndTag();
                return n;
            }
            this.doInclude(page, false);
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.doClearTag();
        }
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            String page = this.getStartPage();
            this.callSetAttributes();
            if (this.themeResourceExists(page)) {
                this.doIncludeTheme(page);
                return 1;
            }
            if (!FileAvailabilityUtil.isAvailable(this.servletContext, page)) {
                this.logUnavailablePage(page);
                return this.processStartTag();
            }
            this.doInclude(page, true);
            return 1;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public void runTag() throws JspException {
        this.doStartTag();
        this.doEndTag();
    }

    public void setPage(String page) {
        this._page = page;
    }

    public void setPortletId(String portletId) {
        if (Validator.isNotNull(portletId)) {
            String rootPortletId = PortletIdCodec.decodePortletName(portletId);
            PortletBag portletBag = PortletBagPool.get(rootPortletId);
            this.servletContext = portletBag.getServletContext();
        }
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setUseCustomPage(boolean useCustomPage) {
        this._useCustomPage = useCustomPage;
    }

    protected void callSetAttributes() {
        Object httpServletRequest = this.getOriginalServletRequest();
        if (this.isCleanUpSetAttributes()) {
            if (this._setAttributeNames == null) {
                this._setAttributeNames = new HashSet<String>();
            } else {
                this._setAttributeNames.clear();
            }
            this._trackedRequest = new TrackedServletRequest((HttpServletRequest)httpServletRequest, this._setAttributeNames);
            httpServletRequest = this._trackedRequest;
        }
        Class<?> clazz = this.getClass();
        httpServletRequest.setAttribute(clazz.getName(), (Object)this);
        this.setNamespacedAttribute((HttpServletRequest)httpServletRequest, "bodyContent", this.getBodyContentWrapper());
        this.setNamespacedAttribute((HttpServletRequest)httpServletRequest, "dynamicAttributes", this.getDynamicAttributes());
        this.setAttributes((HttpServletRequest)httpServletRequest);
    }

    protected void cleanUp() {
    }

    protected void cleanUpSetAttributes() {
        if (this.isCleanUpSetAttributes()) {
            for (String name : this._setAttributeNames) {
                this._trackedRequest.removeAttribute(name);
            }
            this._setAttributeNames.clear();
            this._trackedRequest = null;
        }
    }

    protected void doClearTag() {
        this.clearDynamicAttributes();
        this.clearParams();
        this.clearProperties();
        this.cleanUpSetAttributes();
        if (!ServerDetector.isResin()) {
            this.setPage(null);
            this.setUseCustomPage(true);
            this.cleanUp();
        }
    }

    protected void doInclude(String page, boolean dynamicIncludeAscendingPriority) throws JspException {
        block2: {
            try {
                this.include(page, dynamicIncludeAscendingPriority);
            }
            catch (Exception e) {
                String currentURL = (String)this.request.getAttribute("CURRENT_URL");
                String message = StringBundler.concat("Current URL ", currentURL, " generates exception: ", e.getMessage());
                LogUtil.log(_log, e, message);
                if (!(e instanceof JspException)) break block2;
                throw (JspException)((Object)e);
            }
        }
    }

    protected void doIncludeTheme(String page) throws Exception {
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        Theme theme = (Theme)this.request.getAttribute("THEME");
        ThemeUtil.include(this.servletContext, this.request, httpServletResponse, page, theme);
    }

    protected Object getBodyContentWrapper() {
        final BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return null;
        }
        return new Object(){

            public String toString() {
                return bodyContent.getString();
            }
        };
    }

    protected String getCustomPage(ServletContext servletContext, HttpServletRequest httpServletRequest, String page) {
        UnicodeProperties typeSettingsProperties;
        String customJspServletContextName;
        if (Validator.isNull(page)) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return null;
        }
        Group group = themeDisplay.getScopeGroup();
        if (group.isStagingGroup() && !group.isStagedRemotely()) {
            group = group.getLiveGroup();
        }
        if (Validator.isNull(customJspServletContextName = (typeSettingsProperties = group.getTypeSettingsProperties()).getProperty("customJspServletContextName"))) {
            return null;
        }
        if (customJspServletContextName.contains("/../")) {
            _log.error("Illegal directory traversal in " + customJspServletContextName);
            return null;
        }
        String customPage = CustomJspRegistryUtil.getCustomJspFileName(customJspServletContextName, page);
        if (FileAvailabilityUtil.isAvailable(servletContext, customPage)) {
            return customPage;
        }
        return null;
    }

    protected String getEndPage() {
        return null;
    }

    protected HttpServletRequest getOriginalServletRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected String getPage() {
        return this._page;
    }

    protected String getStartPage() {
        return null;
    }

    protected void include(String page, boolean doStartTag) throws Exception {
        String customPage;
        HttpServletResponse httpServletResponse = null;
        Class<?> clazz = this.getClass();
        String tagClassName = clazz.getName();
        String tagDynamicId = null;
        String tagPointPrefix = null;
        tagPointPrefix = doStartTag ? "doStartTag#" : "doEndTag#";
        TagDynamicIdFactory tagDynamicIdFactory = TagDynamicIdFactoryRegistry.getTagDynamicIdFactory(tagClassName);
        if (tagDynamicIdFactory != null) {
            httpServletResponse = PipingServletResponse.createPipingServletResponse(this.pageContext);
            tagDynamicId = tagDynamicIdFactory.getTagDynamicId(this.request, httpServletResponse, this);
            TagDynamicIncludeUtil.include(this.request, httpServletResponse, tagClassName, tagDynamicId, tagPointPrefix + "before", doStartTag);
        }
        if (this._useCustomPage && Validator.isNotNull(customPage = this.getCustomPage(this.servletContext, this.request, page))) {
            page = customPage;
        }
        if (_THEME_JSP_OVERRIDE_ENABLED) {
            this.request.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT", (Object)this._strict);
        }
        this.includePage(page, PipingServletResponse.createPipingServletResponse(this.pageContext));
        if (_THEME_JSP_OVERRIDE_ENABLED) {
            this.request.removeAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT");
        }
        if (tagDynamicIdFactory != null) {
            TagDynamicIncludeUtil.include(this.request, httpServletResponse, tagClassName, tagDynamicId, tagPointPrefix + "after", doStartTag);
        }
    }

    protected void includePage(String page, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher(this.servletContext, page);
        requestDispatcher.include((ServletRequest)this.request, (ServletResponse)httpServletResponse);
    }

    protected boolean isCleanUpSetAttributes() {
        return false;
    }

    protected boolean isPortalPage(String page) {
        return page.startsWith("/html/taglib/") && (page.endsWith("/end.jsp") || page.endsWith("/page.jsp") || page.endsWith("/start.jsp"));
    }

    protected boolean isUseCustomPage() {
        return this._useCustomPage;
    }

    protected void logUnavailablePage(String page) {
        if (page == null || !_log.isDebugEnabled()) {
            return;
        }
        StringBundler sb = new StringBundler(8);
        sb.append("Unable to find ");
        sb.append(page);
        sb.append(" in the context ");
        String contextPath = PortalUtil.getPathContext(this.servletContext.getContextPath());
        if (contextPath.equals("")) {
            contextPath = "/";
        }
        sb.append(contextPath);
        sb.append(".");
        boolean portalContext = false;
        String portalContextPath = PortalUtil.getPathContext();
        if (portalContextPath.equals("")) {
            portalContextPath = "/";
        }
        if (contextPath.equals(portalContextPath)) {
            portalContext = true;
        }
        if (this.isPortalPage(page)) {
            if (portalContext) {
                return;
            }
            sb.append(" You must not use a taglib from a module and set the ");
            sb.append("attribute \"servletContext\". Inline the content ");
            sb.append("directly where the taglib is invoked.");
        } else if (portalContext) {
            Class<?> clazz = this.getClass();
            if (clazz.equals(IncludeTag.class)) {
                sb.append(" You must set the attribute \"servletContext\" ");
                sb.append("with the value \"<%= application %>\" when ");
                sb.append("invoking a taglib from a module.");
            } else {
                sb.append(" You must not use a taglib from a module and set ");
                sb.append("the attribute \"file\". Inline the content ");
                sb.append("directly where the taglib is invoked.");
            }
        }
        _log.debug(sb.toString());
    }

    protected int processEndTag() throws Exception {
        return 6;
    }

    protected int processStartTag() throws Exception {
        return 1;
    }

    protected void setAttributes(HttpServletRequest httpServletRequest) {
    }

    protected boolean themeResourceExists(String page) throws Exception {
        ThemeDisplay themeDisplay;
        if (page == null || !_THEME_JSP_OVERRIDE_ENABLED || this._strict) {
            return false;
        }
        Theme theme = (Theme)this.request.getAttribute("THEME");
        if (theme == null && (themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null) {
            theme = themeDisplay.getTheme();
        }
        if (theme == null) {
            return false;
        }
        String portletId = ThemeUtil.getPortletId(this.request);
        boolean exists = theme.resourceExists(this.servletContext, portletId, page);
        if (_log.isDebugEnabled() && exists) {
            String resourcePath = theme.getResourcePath(this.servletContext, null, page);
            _log.debug(resourcePath);
        }
        return exists;
    }

    private static class TrackedServletRequest
    extends HttpServletRequestWrapper {
        private final Set<String> _setAttributeNames;

        public void setAttribute(String name, Object obj) {
            this._setAttributeNames.add(name);
            super.setAttribute(name, obj);
        }

        private TrackedServletRequest(HttpServletRequest httpServletRequest, Set<String> setAttributeNames) {
            super(httpServletRequest);
            this._setAttributeNames = setAttributeNames;
        }
    }
}

