/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class UserPortraitTag
extends IncludeTag {
    private static final String _PAGE = "/html/taglib/ui/user_portrait/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(UserPortraitTag.class);
    private String _cssClass = "";
    private String _size = "";
    private User _user;

    public static String getUserPortraitHTML(String cssClass, String size, User user, ThemeDisplay themeDisplay) {
        String portraitURL = UserPortraitTag._getPortraitURL(user, themeDisplay);
        if (Validator.isNull(portraitURL)) {
            StringBundler sb = new StringBundler(13);
            sb.append("<span class=\"sticker sticker-circle sticker-light ");
            if (Validator.isNotNull(size)) {
                sb.append(UserPortraitTag._getSizeCssClass(size));
                sb.append(' ');
            }
            sb.append("user-icon-color-");
            sb.append(user == null ? 0L : user.getUserId() % 10L);
            sb.append(' ');
            sb.append(cssClass);
            sb.append("\"><span class=\"inline-item\">");
            sb.append("<svg class=\"lexicon-icon\">");
            sb.append("<use href=\"");
            sb.append(themeDisplay.getPathThemeImages());
            sb.append("/lexicon/icons.svg#user\" /></svg>");
            sb.append("</span></span>");
            return sb.toString();
        }
        StringBundler sb = new StringBundler(8);
        sb.append("<span class=\"rounded-circle sticker sticker-primary ");
        if (Validator.isNotNull(size)) {
            sb.append(UserPortraitTag._getSizeCssClass(size));
            sb.append(' ');
        }
        sb.append(cssClass);
        sb.append("\"><span class=\"sticker-overlay\">");
        sb.append("<img alt=\"thumbnail\" class=\"img-fluid\" src=\"");
        sb.append(portraitURL);
        sb.append("\" /></span></span>");
        return sb.toString();
    }

    @Deprecated
    public static String getUserPortraitHTML(String cssClass, Supplier<String> userPortraitURLSupplier) {
        StringBundler sb = new StringBundler(7);
        sb.append("<span class=\"sticker sticker-circle sticker-light ");
        sb.append(cssClass);
        sb.append("\">");
        sb.append("<span class=\"sticker-overlay\">");
        sb.append("<img alt=\"\" class=\"sticker-img\" src=\"");
        sb.append(HtmlUtil.escape(userPortraitURLSupplier.get()));
        sb.append("\"></span></span>");
        return sb.toString();
    }

    public static String getUserPortraitHTML(String cssClass, User user, ThemeDisplay themeDisplay) {
        return UserPortraitTag.getUserPortraitHTML(cssClass, null, user, themeDisplay);
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public String getSize() {
        return this._size;
    }

    public User getUser() {
        return this._user;
    }

    public long getUserId() {
        if (this._user == null) {
            return 0L;
        }
        return this._user.getUserId();
    }

    @Override
    public int processEndTag() throws Exception {
        JspWriter jspWriter = this.pageContext.getOut();
        User user = this.getUser();
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String userPortraitHTML = UserPortraitTag.getUserPortraitHTML(this._cssClass, this._size, user, themeDisplay);
        jspWriter.write(userPortraitHTML);
        return 6;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    @Deprecated
    public void setImageCssClass(String imageCssClass) {
    }

    public void setSize(String size) {
        this._size = size;
    }

    public void setUser(User user) {
        this._user = user;
    }

    public void setUserId(long userId) {
        this._user = UserLocalServiceUtil.fetchUser(userId);
    }

    @Deprecated
    public void setUserName(String userName) {
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._cssClass = "";
        this._size = "";
        this._user = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Deprecated
    protected String getPortraitURL(User user) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return UserPortraitTag._getPortraitURL(user, themeDisplay);
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return false;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
    }

    private static String _getPortraitURL(User user, ThemeDisplay themeDisplay) {
        try {
            if (user == null || user.getPortraitId() == 0L) {
                return null;
            }
            return user.getPortraitURL(themeDisplay);
        }
        catch (PortalException pe) {
            _log.error(pe, pe);
            return null;
        }
    }

    private static String _getSizeCssClass(String size) {
        return "sticker-" + size;
    }
}

