/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.aui.ScriptTag;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;

public class SuccessTag
extends IncludeTag
implements BodyTag {
    private static final String _ATTRIBUTE_NAMESPACE = "liferay-ui:success:";
    private static final String _CONTENT_EMBED_TMPL = StringUtil.read(SuccessTag.class, "success/embed.tmpl");
    private static final String _CONTENT_TOAST_TMPL = StringUtil.read(SuccessTag.class, "success/toast.tmpl");
    private static final String _PAGE = "/html/taglib/ui/success/page.jsp";
    private boolean _embed;
    private boolean _hasMessage;
    private String _key;
    private String _message;
    private String _targetNode;
    private int _timeout = 5000;
    private boolean _translateMessage = true;

    @Override
    public int doEndTag() throws JspException {
        if (this._hasMessage) {
            return super.doEndTag();
        }
        return 6;
    }

    @Override
    public int doStartTag() throws JspException {
        this.setAttributeNamespace(_ATTRIBUTE_NAMESPACE);
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            if (SessionMessages.contains(this.request, this._key)) {
                this._hasMessage = true;
                return super.doStartTag();
            }
        } else if (MultiSessionMessages.contains(portletRequest, this._key)) {
            this._hasMessage = true;
            return super.doStartTag();
        }
        return 0;
    }

    public String getKey() {
        return this._key;
    }

    public String getMessage() {
        return this._message;
    }

    public String getTargetNode() {
        return this._targetNode;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean isEmbed() {
        return this._embed;
    }

    public boolean isTranslateMessage() {
        return this._translateMessage;
    }

    @Override
    public int processEndTag() throws Exception {
        String message = this._message;
        String bodyContentString = null;
        Object bodyContent = this.getBodyContentWrapper();
        if (bodyContent != null) {
            bodyContentString = bodyContent.toString();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.request, themeDisplay.getLocale());
        if (Validator.isNotNull(bodyContentString)) {
            message = bodyContentString;
        } else if (this._translateMessage) {
            message = LanguageUtil.get(resourceBundle, message);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("pathThemeImages", themeDisplay.getPathThemeImages());
        values.put("title", LanguageUtil.get(resourceBundle, "success-colon"));
        if (this._embed) {
            values.put("message", HtmlUtil.escape(message));
            String result = StringUtil.replace(_CONTENT_EMBED_TMPL, "$", "$", values);
            JspWriter jspWriter = this.pageContext.getOut();
            jspWriter.write(result);
        } else {
            values.put("message", HtmlUtil.escapeJS(message));
            String result = StringUtil.replace(_CONTENT_TOAST_TMPL, "$", "$", values);
            ScriptTag.doTag(null, "metal-dom/src/all/dom as dom,clay-alert/src/ClayToast as ClayToast", null, result, this.getBodyContent(), this.pageContext);
        }
        return 6;
    }

    public void setEmbed(boolean embed) {
        this._embed = embed;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setTargetNode(String targetNode) {
        this._targetNode = targetNode;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public void setTranslateMessage(boolean translateMessage) {
        this._translateMessage = translateMessage;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._embed = false;
        this._hasMessage = false;
        this._key = null;
        this._message = null;
        this._targetNode = null;
        this._timeout = 5000;
        this._translateMessage = true;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return super.isCleanUpSetAttributes();
    }

    @Override
    protected int processStartTag() throws Exception {
        return 2;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
    }
}

