/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.ratings.kernel.RatingsType;
import com.liferay.ratings.kernel.definition.PortletRatingsDefinitionUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.taglib.util.IncludeTag;
import javax.servlet.http.HttpServletRequest;

public class RatingsTag
extends IncludeTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;
    private static final int _DEFAULT_NUMBER_OF_STARS = GetterUtil.getInteger(PropsUtil.get("ratings.default.number.of.stars"));
    private static final String _PAGE = "/html/taglib/ui/ratings/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(RatingsTag.class);
    private String _className;
    private long _classPK;
    private Boolean _inTrash;
    private int _numberOfStars = _DEFAULT_NUMBER_OF_STARS;
    private RatingsEntry _ratingsEntry;
    private RatingsStats _ratingsStats;
    private boolean _round = true;
    private boolean _setRatingsEntry;
    private boolean _setRatingsStats;
    private String _type;
    private String _url;

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public int getNumberOfStars() {
        return this._numberOfStars;
    }

    public RatingsEntry getRatingsEntry() {
        return this._ratingsEntry;
    }

    public RatingsStats getRatingsStats() {
        return this._ratingsStats;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean isInTrash() {
        return this._inTrash;
    }

    public boolean isRound() {
        return this._round;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setInTrash(boolean inTrash) {
        this._inTrash = inTrash;
    }

    public void setNumberOfStars(int numberOfStars) {
        this._numberOfStars = numberOfStars;
    }

    public void setRatingsEntry(RatingsEntry ratingsEntry) {
        this._ratingsEntry = ratingsEntry;
        this._setRatingsEntry = true;
    }

    public void setRatingsStats(RatingsStats ratingsStats) {
        this._ratingsStats = ratingsStats;
        this._setRatingsStats = true;
    }

    public void setRound(boolean round) {
        this._round = round;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._className = null;
        this._classPK = 0L;
        this._inTrash = null;
        this._numberOfStars = _DEFAULT_NUMBER_OF_STARS;
        this._ratingsEntry = null;
        this._ratingsStats = null;
        this._round = true;
        this._setRatingsEntry = false;
        this._setRatingsStats = false;
        this._type = null;
        this._url = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    protected String getType(HttpServletRequest httpServletRequest) {
        if (Validator.isNotNull(this._type)) {
            return this._type;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getSiteGroup();
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        RatingsType ratingsType = null;
        if (group != null) {
            try {
                ratingsType = PortletRatingsDefinitionUtil.getRatingsType(themeDisplay.getCompanyId(), group.getGroupId(), this._className);
            }
            catch (PortalException pe) {
                _log.error("Unable to get ratings type for group " + group.getGroupId(), pe);
            }
        }
        if (ratingsType == null) {
            ratingsType = RatingsType.STARS;
        }
        return ratingsType.getValue();
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-ui:ratings:className", (Object)this._className);
        httpServletRequest.setAttribute("liferay-ui:ratings:classPK", (Object)String.valueOf(this._classPK));
        if (this._inTrash != null) {
            httpServletRequest.setAttribute("liferay-ui:ratings:inTrash", (Object)this._inTrash);
        }
        httpServletRequest.setAttribute("liferay-ui:ratings:numberOfStars", (Object)String.valueOf(this._numberOfStars));
        httpServletRequest.setAttribute("liferay-ui:ratings:ratingsEntry", (Object)this._ratingsEntry);
        httpServletRequest.setAttribute("liferay-ui:ratings:ratingsStats", (Object)this._ratingsStats);
        httpServletRequest.setAttribute("liferay-ui:ratings:round", (Object)String.valueOf(this._round));
        httpServletRequest.setAttribute("liferay-ui:ratings:setRatingsEntry", (Object)String.valueOf(this._setRatingsEntry));
        httpServletRequest.setAttribute("liferay-ui:ratings:setRatingsStats", (Object)String.valueOf(this._setRatingsStats));
        httpServletRequest.setAttribute("liferay-ui:ratings:type", (Object)this.getType(httpServletRequest));
        httpServletRequest.setAttribute("liferay-ui:ratings:url", (Object)this._url);
    }
}

