/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.taglib.portletext.RuntimeTag;
import com.liferay.taglib.ui.MessageTag;
import com.liferay.taglib.util.IncludeTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class LayoutCommonTag
extends IncludeTag {
    private static final String[] _LAYOUT_STATIC_PORTLETS_ALL = PropsUtil.getArray("layout.static.portlets.all");
    private static final String _PAGE = "/html/taglib/ui/layout_common/page.jsp";
    private static final boolean _WEB_SERVER_DISPLAY_NODE = GetterUtil.getBoolean(PropsUtil.get("web.server.display.node"));
    private boolean _includeStaticPortlets;
    private boolean _includeWebServerDisplayNode;

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._includeStaticPortlets = false;
        this._includeWebServerDisplayNode = false;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return super.isCleanUpSetAttributes();
    }

    @Override
    protected int processEndTag() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isStatePopUp()) {
            if (!themeDisplay.isStateExclusive() && !themeDisplay.isWidget()) {
                this._includeStaticPortlets = true;
            }
            if (_WEB_SERVER_DISPLAY_NODE) {
                this._includeWebServerDisplayNode = true;
            }
        }
        if (this._includeStaticPortlets) {
            Company company = themeDisplay.getCompany();
            HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
            for (String portletId : _LAYOUT_STATIC_PORTLETS_ALL) {
                if (!PortletLocalServiceUtil.hasPortlet(company.getCompanyId(), portletId)) continue;
                RuntimeTag.doTag(portletId, this.pageContext, this.request, httpServletResponse);
            }
        }
        JspWriter jspWriter = this.pageContext.getOut();
        if (this._includeWebServerDisplayNode) {
            jspWriter.write("<div class=\"alert alert-info\">");
            MessageTag.doTag("node", this.pageContext);
            jspWriter.write(": ");
            jspWriter.write(StringUtil.toLowerCase(PortalUtil.getComputerName()));
            jspWriter.write(":");
            jspWriter.write(String.valueOf(PortalUtil.getPortalLocalPort(false)));
            jspWriter.write("</div>");
        }
        jspWriter.write("<form action=\"#\" class=\"hide\" id=\"hrefFm\" method=\"post\" name=\"hrefFm\"><span></span><input hidden type=\"submit\"/></form>");
        return 6;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
    }
}

