/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.editor.Editor;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.taglib.BaseValidatorTagSupport;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InputEditorTag
extends BaseValidatorTagSupport {
    private static final String _EDITOR_WYSIWYG_DEFAULT = PropsUtil.get("editor.wysiwyg.default");
    private static final String _TOOLBAR_SET_DEFAULT = "liferay";
    private static final Function<InvocationHandler, Map<?, ?>> _mapProxyProviderFunction = ProxyUtil.getProxyProviderFunction(Map.class);
    private static final ServiceTrackerMap<String, Editor> _serviceTrackerMap = ServiceTrackerCollections.openSingleValueMap(Editor.class, null, new ServiceReferenceMapper<String, Editor>(){

        @Override
        public void map(ServiceReference<Editor> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            Editor editor = registry.getService(serviceReference);
            emitter.emit(editor.getName());
        }
    });
    private boolean _allowBrowseDocuments = true;
    private boolean _autoCreate = true;
    private String _configKey;
    private Map<String, String> _configParams;
    private String _contents;
    private String _contentsLanguageId;
    private String _cssClass;
    private Map<String, Object> _data;
    private String _editorName;
    private Map<String, String> _fileBrowserParams;
    private String _height;
    private String _initMethod = "initEditor";
    private boolean _inlineEdit;
    private String _inlineEditSaveURL;
    private String _name = "editor";
    private String _onBlurMethod;
    private String _onChangeMethod;
    private String _onFocusMethod;
    private String _onInitMethod;
    private String _placeholder;
    private boolean _required;
    private boolean _resizable = true;
    private boolean _showSource = true;
    private boolean _skipEditorLoading;
    private String _toolbarSet = "liferay";
    private String _width;

    public static Editor getEditor(HttpServletRequest httpServletRequest, String editorName) {
        if (!BrowserSnifferUtil.isRtf(httpServletRequest)) {
            return _serviceTrackerMap.getService("simple");
        }
        if (Validator.isNull(editorName)) {
            return _serviceTrackerMap.getService(_EDITOR_WYSIWYG_DEFAULT);
        }
        if (!_serviceTrackerMap.containsKey(editorName)) {
            return _serviceTrackerMap.getService(_EDITOR_WYSIWYG_DEFAULT);
        }
        return _serviceTrackerMap.getService(editorName);
    }

    public Map<String, String> getConfigParams() {
        return this._configParams;
    }

    public String getContents() {
        return this._contents;
    }

    public String getCssClass() {
        return this._cssClass;
    }

    public Map<String, String> getFileBrowserParams() {
        return this._fileBrowserParams;
    }

    public String getHeight() {
        return this._height;
    }

    public String getInlineEditSaveURL() {
        return this._inlineEditSaveURL;
    }

    @Override
    public String getInputName() {
        return this.getConfigKey();
    }

    public String getName() {
        return this._name;
    }

    public String getOnBlurMethod() {
        return this._onBlurMethod;
    }

    public String getOnChangeMethod() {
        return this._onChangeMethod;
    }

    public String getOnFocusMethod() {
        return this._onFocusMethod;
    }

    public String getOnInitMethod() {
        return this._onInitMethod;
    }

    public String getPlaceholder() {
        return this._placeholder;
    }

    public String getWidth() {
        return this._width;
    }

    public boolean isAllowBrowseDocuments() {
        return this._allowBrowseDocuments;
    }

    public boolean isAutoCreate() {
        return this._autoCreate;
    }

    public boolean isInlineEdit() {
        return this._inlineEdit;
    }

    public boolean isRequired() {
        return this._required;
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public boolean isShowSource() {
        return this._showSource;
    }

    public boolean isSkipEditorLoading() {
        return this._skipEditorLoading;
    }

    public void setAllowBrowseDocuments(boolean allowBrowseDocuments) {
        this._allowBrowseDocuments = allowBrowseDocuments;
    }

    public void setAutoCreate(boolean autoCreate) {
        this._autoCreate = autoCreate;
    }

    public void setConfigKey(String configKey) {
        this._configKey = configKey;
    }

    public void setConfigParams(Map<String, String> configParams) {
        this._configParams = configParams;
    }

    public void setContents(String contents) {
        this._contents = contents;
    }

    public void setContentsLanguageId(String contentsLanguageId) {
        this._contentsLanguageId = contentsLanguageId;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    @Deprecated
    public void setEditorImpl(String editorImpl) {
        this._editorName = PropsUtil.get(editorImpl);
    }

    public void setEditorName(String editorName) {
        this._editorName = editorName;
    }

    public void setFileBrowserParams(Map<String, String> fileBrowserParams) {
        this._fileBrowserParams = fileBrowserParams;
    }

    public void setHeight(String height) {
        this._height = height;
    }

    @Deprecated
    public void setInitMethod(String initMethod) {
        this._initMethod = initMethod;
    }

    public void setInlineEdit(boolean inlineEdit) {
        this._inlineEdit = inlineEdit;
    }

    public void setInlineEditSaveURL(String inlineEditSaveURL) {
        this._inlineEditSaveURL = inlineEditSaveURL;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOnBlurMethod(String onBlurMethod) {
        this._onBlurMethod = onBlurMethod;
    }

    public void setOnChangeMethod(String onChangeMethod) {
        this._onChangeMethod = onChangeMethod;
    }

    public void setOnFocusMethod(String onFocusMethod) {
        this._onFocusMethod = onFocusMethod;
    }

    public void setOnInitMethod(String onInitMethod) {
        this._onInitMethod = onInitMethod;
    }

    public void setPlaceholder(String placeholder) {
        this._placeholder = placeholder;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }

    public void setShowSource(boolean showSource) {
        this._showSource = showSource;
    }

    public void setSkipEditorLoading(boolean skipEditorLoading) {
        this._skipEditorLoading = skipEditorLoading;
    }

    public void setToolbarSet(String toolbarSet) {
        this._toolbarSet = toolbarSet;
    }

    public void setWidth(String width) {
        this._width = width;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._allowBrowseDocuments = true;
        this._autoCreate = true;
        this._configKey = null;
        this._configParams = null;
        this._contents = null;
        this._contentsLanguageId = null;
        this._cssClass = null;
        this._data = null;
        this._editorName = null;
        this._fileBrowserParams = null;
        this._height = null;
        this._initMethod = "initEditor";
        this._inlineEdit = false;
        this._inlineEditSaveURL = null;
        this._name = "editor";
        this._onBlurMethod = null;
        this._onChangeMethod = null;
        this._onFocusMethod = null;
        this._onInitMethod = null;
        this._placeholder = null;
        this._required = false;
        this._resizable = true;
        this._showSource = true;
        this._skipEditorLoading = false;
        this._toolbarSet = _TOOLBAR_SET_DEFAULT;
        this._width = null;
    }

    protected String getConfigKey() {
        String configKey = this._configKey;
        if (Validator.isNull(configKey)) {
            configKey = this._name;
        }
        return configKey;
    }

    protected String getContentsLanguageId() {
        if (this._contentsLanguageId == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._contentsLanguageId = themeDisplay.getLanguageId();
        }
        return this._contentsLanguageId;
    }

    protected String getCssClasses() {
        Portlet portlet = (Portlet)this.request.getAttribute("RENDER_PORTLET");
        String cssClasses = "portlet ";
        if (portlet != null) {
            cssClasses = cssClasses + portlet.getCssClassWrapper();
        }
        return cssClasses;
    }

    protected Map<String, Object> getData() {
        String portletId = (String)this.request.getAttribute("PORTLET_ID");
        if (portletId == null) {
            return this._data;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (!attributeName.startsWith("liferay-ui:input-editor")) continue;
            attributes.put(attributeName, this.request.getAttribute(attributeName));
        }
        attributes.put("liferay-ui:input-editor:namespace", this.getNamespace());
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration(PortletIdCodec.decodePortletName(portletId), this.getConfigKey(), this.getEditorName(this.request), attributes, themeDisplay, this.getRequestBackedPortletURLFactory());
        Map<String, Object> data = editorConfiguration.getData();
        if (MapUtil.isNotEmpty(this._data)) {
            MapUtil.merge(this._data, data);
        }
        return data;
    }

    protected Editor getEditor(HttpServletRequest httpServletRequest) {
        return InputEditorTag.getEditor(httpServletRequest, this._editorName);
    }

    protected String getEditorName(HttpServletRequest httpServletRequest) {
        Editor editor = this.getEditor(httpServletRequest);
        return editor.getName();
    }

    protected String getEditorResourceType() {
        Editor editor = this.getEditor(this.request);
        return editor.getResourceType();
    }

    protected String getNamespace() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            return AUIUtil.getNamespace(this.request);
        }
        return AUIUtil.getNamespace(portletRequest, portletResponse);
    }

    @Override
    protected String getPage() {
        Editor editor = this.getEditor(this.request);
        return editor.getJspPath();
    }

    protected RequestBackedPortletURLFactory getRequestBackedPortletURLFactory() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return RequestBackedPortletURLFactoryUtil.create(this.request);
        }
        return RequestBackedPortletURLFactoryUtil.create(portletRequest);
    }

    protected String getToolbarSet() {
        if (Validator.isNotNull(this._toolbarSet)) {
            return this._toolbarSet;
        }
        return _TOOLBAR_SET_DEFAULT;
    }

    @Override
    protected void includePage(String page, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.servletContext = PortalWebResourcesUtil.getServletContext(this.getEditorResourceType());
        super.includePage(page, httpServletResponse);
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-ui:input-editor:allowBrowseDocuments", (Object)String.valueOf(this._allowBrowseDocuments));
        httpServletRequest.setAttribute("liferay-ui:input-editor:autoCreate", (Object)String.valueOf(this._autoCreate));
        httpServletRequest.setAttribute("liferay-ui:input-editor:configParams", this._configParams);
        httpServletRequest.setAttribute("liferay-ui:input-editor:contents", (Object)this._contents);
        httpServletRequest.setAttribute("liferay-ui:input-editor:contentsLanguageId", (Object)this.getContentsLanguageId());
        httpServletRequest.setAttribute("liferay-ui:input-editor:cssClass", (Object)this._cssClass);
        httpServletRequest.setAttribute("liferay-ui:input-editor:cssClasses", (Object)this.getCssClasses());
        httpServletRequest.setAttribute("liferay-ui:input-editor:editorName", (Object)this.getEditorName(httpServletRequest));
        httpServletRequest.setAttribute("liferay-ui:input-editor:fileBrowserParams", this._fileBrowserParams);
        httpServletRequest.setAttribute("liferay-ui:input-editor:height", (Object)this._height);
        httpServletRequest.setAttribute("liferay-ui:input-editor:initMethod", (Object)this._initMethod);
        httpServletRequest.setAttribute("liferay-ui:input-editor:inlineEdit", (Object)String.valueOf(this._inlineEdit));
        httpServletRequest.setAttribute("liferay-ui:input-editor:inlineEditSaveURL", (Object)this._inlineEditSaveURL);
        httpServletRequest.setAttribute("liferay-ui:input-editor:name", (Object)this._name);
        httpServletRequest.setAttribute("liferay-ui:input-editor:onBlurMethod", (Object)this._onBlurMethod);
        httpServletRequest.setAttribute("liferay-ui:input-editor:onChangeMethod", (Object)this._onChangeMethod);
        httpServletRequest.setAttribute("liferay-ui:input-editor:onFocusMethod", (Object)this._onFocusMethod);
        httpServletRequest.setAttribute("liferay-ui:input-editor:onInitMethod", (Object)this._onInitMethod);
        if (Validator.isNull(this._placeholder)) {
            ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
            this._placeholder = LanguageUtil.get(resourceBundle, "write-your-content-here");
        }
        httpServletRequest.setAttribute("liferay-ui:input-editor:placeholder", (Object)this._placeholder);
        httpServletRequest.setAttribute("liferay-ui:input-editor:required", (Object)String.valueOf(this._required));
        httpServletRequest.setAttribute("liferay-ui:input-editor:resizable", (Object)String.valueOf(this._resizable));
        httpServletRequest.setAttribute("liferay-ui:input-editor:showSource", (Object)String.valueOf(this._showSource));
        httpServletRequest.setAttribute("liferay-ui:input-editor:skipEditorLoading", (Object)String.valueOf(this._skipEditorLoading));
        httpServletRequest.setAttribute("liferay-ui:input-editor:toolbarSet", (Object)this.getToolbarSet());
        httpServletRequest.setAttribute("liferay-ui:input-editor:width", (Object)this._width);
        httpServletRequest.setAttribute("liferay-ui:input-editor:data", _mapProxyProviderFunction.apply(new LazyDataInvocationHandler()));
    }

    private class LazyDataInvocationHandler
    implements InvocationHandler {
        private Map<String, Object> _data;

        private LazyDataInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            if (this._data == null) {
                this._data = InputEditorTag.this.getData();
            }
            return method.invoke(this._data, args);
        }
    }
}

