/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.taglib.ui.IconTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ResourceBundle;

public class IconDeleteTag
extends IconTag {
    private static final String _PAGE = "/html/taglib/ui/icon_delete/page.jsp";
    private String _confirmation;
    private ResourceBundle _resourceBundle;
    private boolean _showIcon;
    private boolean _trash;

    public String getConfirmation() {
        return this._confirmation;
    }

    public boolean isShowIcon() {
        return this._showIcon;
    }

    public boolean isTrash() {
        return this._trash;
    }

    public void setConfirmation(String confirmation) {
        this._confirmation = confirmation;
    }

    public void setShowIcon(boolean showIcon) {
        this._showIcon = showIcon;
    }

    public void setTrash(boolean trash) {
        this._trash = trash;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._confirmation = null;
        this._resourceBundle = null;
        this._showIcon = false;
        this._trash = false;
    }

    @Override
    protected String getPage() {
        String url;
        if (FileAvailabilityUtil.isAvailable(this.servletContext, _PAGE)) {
            return _PAGE;
        }
        String cssClass = GetterUtil.getString(this.getCssClass());
        this.setCssClass(cssClass.concat(" item-remove"));
        String icon = "";
        if (this._showIcon && Validator.isNull(icon = this.getIcon())) {
            icon = this._trash ? "trash" : "times-circle";
        }
        this.setIcon(icon);
        this.setMarkupView("lexicon");
        if (Validator.isNull(this.getMessage())) {
            if (this._trash) {
                this.setMessage(LanguageUtil.get(this._getResourceBundle(), "move-to-recycle-bin"));
            } else {
                this.setMessage(LanguageUtil.get(this._getResourceBundle(), "delete"));
            }
        }
        if ((url = this.getUrl()).startsWith("javascript:if (confirm('")) {
            return super.getPage();
        }
        if (url.startsWith("javascript:")) {
            url = url.substring(11);
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            url = "submitForm(document.hrefFm, '".concat(HtmlUtil.escapeJS(url)).concat("');");
        }
        if (!this._trash) {
            StringBundler sb = new StringBundler(5);
            sb.append("javascript:if (confirm('");
            if (Validator.isNotNull(this._confirmation)) {
                sb.append(UnicodeLanguageUtil.get(this._getResourceBundle(), this._confirmation));
            } else {
                String confirmation = "are-you-sure-you-want-to-delete-this";
                sb.append(UnicodeLanguageUtil.get(this._getResourceBundle(), confirmation));
            }
            sb.append("')) { ");
            sb.append(url);
            sb.append(" } else { self.focus(); }");
            url = sb.toString();
        } else {
            url = "javascript:".concat(url);
        }
        this.setUrl(url);
        return super.getPage();
    }

    private ResourceBundle _getResourceBundle() {
        if (this._resourceBundle == null) {
            this._resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
        }
        return this._resourceBundle;
    }
}

