/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;

public class ErrorTag
extends IncludeTag
implements BodyTag {
    private static final String _ATTRIBUTE_NAMESPACE = "liferay-ui:error:";
    private static final String _PAGE = "/html/taglib/ui/error/page.jsp";
    private boolean _embed = true;
    private Class<?> _exception;
    private String _focusField;
    private boolean _hasError;
    private String _key;
    private String _message;
    private String _rowBreak = "";
    private String _targetNode;
    private boolean _translateMessage = true;

    @Override
    public int doEndTag() throws JspException {
        if (this._hasError && this._isShowAlert()) {
            return super.doEndTag();
        }
        return 6;
    }

    @Override
    public int doStartTag() throws JspException {
        this.setAttributeNamespace(_ATTRIBUTE_NAMESPACE);
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (SessionErrors.isEmpty(portletRequest)) {
            return 0;
        }
        this._hasError = true;
        if (!SessionErrors.contains(portletRequest, this._key)) {
            return 0;
        }
        Object value = this.getException(portletRequest);
        if (value == null) {
            return 0;
        }
        this.pageContext.setAttribute("errorException", value);
        return super.doStartTag();
    }

    public String getFocusField() {
        return this._focusField;
    }

    public String getKey() {
        return this._key;
    }

    public String getMessage() {
        return this._message;
    }

    public String getRowBreak() {
        return this._rowBreak;
    }

    public String getTargetNode() {
        return this._targetNode;
    }

    public boolean isEmbed() {
        return this._embed;
    }

    public boolean isTranslateMessage() {
        return this._translateMessage;
    }

    public void setEmbed(boolean embed) {
        this._embed = embed;
    }

    public void setException(Class<?> exception) {
        this._exception = exception;
        if (this._exception != null) {
            this._key = this._exception.getName();
        }
    }

    public void setFocusField(String focusField) {
        this._focusField = focusField;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setRowBreak(String rowBreak) {
        this._rowBreak = HtmlUtil.unescape(rowBreak);
    }

    public void setTargetNode(String targetNode) {
        this._targetNode = targetNode;
    }

    public void setTranslateMessage(boolean translateMessage) {
        this._translateMessage = translateMessage;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._embed = true;
        this._exception = null;
        this._focusField = null;
        this._hasError = false;
        this._key = null;
        this._message = null;
        this._rowBreak = "";
        this._targetNode = null;
        this._translateMessage = true;
    }

    protected Object getException(PortletRequest portletRequest) {
        Object value = null;
        value = this._exception != null ? SessionErrors.get(portletRequest, this._exception.getName()) : SessionErrors.get(portletRequest, this._key);
        return value;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected int processStartTag() throws Exception {
        return 2;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        httpServletRequest.setAttribute("liferay-ui:error:alertIcon", (Object)this._getAlertIcon());
        httpServletRequest.setAttribute("liferay-ui:error:alertMessage", (Object)this._getAlertMessage());
        httpServletRequest.setAttribute("liferay-ui:error:alertStyle", (Object)this._getAlertStyle());
        httpServletRequest.setAttribute("liferay-ui:error:alertTitle", (Object)this._getAlertTitle());
        httpServletRequest.setAttribute("liferay-ui:error:embed", (Object)String.valueOf(this._embed));
        httpServletRequest.setAttribute("liferay-ui:error:rowBreak", (Object)this._rowBreak);
        if (SessionErrors.contains(portletRequest, this._key)) {
            String errorMarkerKey = (String)httpServletRequest.getAttribute("liferay-ui:error-marker:key");
            String errorMarkerValue = (String)httpServletRequest.getAttribute("liferay-ui:error-marker:value");
            if (Validator.isNotNull(errorMarkerKey) && Validator.isNotNull(errorMarkerValue)) {
                httpServletRequest.setAttribute(errorMarkerKey, (Object)errorMarkerValue);
                Object exception = this.getException(portletRequest);
                if (exception instanceof Exception) {
                    httpServletRequest.setAttribute("liferay-ui:error:exception", exception);
                }
                httpServletRequest.setAttribute("liferay-ui:error:focusField", (Object)this._focusField);
            }
        }
    }

    private String _getAlertIcon() {
        if (this._key != null && Validator.isNull(this._message)) {
            return "exclamation-full";
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (SessionErrors.contains(portletRequest, "warning")) {
            return "warning-full";
        }
        return "exclamation-full";
    }

    private String _getAlertMessage() {
        if (this._key != null && Validator.isNull(this._message)) {
            return this._getBodyContentString();
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (SessionErrors.contains(portletRequest, "warning")) {
            String alertMessage = this._message;
            if (this._message == null) {
                alertMessage = (String)SessionErrors.get(portletRequest, "warning");
            }
            if (this._translateMessage) {
                ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                alertMessage = LanguageUtil.get(this.request, resourceBundle, alertMessage);
            }
            return alertMessage;
        }
        if (this._key == null) {
            return LanguageUtil.get(this.request, "your-request-failed-to-complete");
        }
        if (SessionErrors.contains(portletRequest, this._key)) {
            String alertMessage = this._message;
            if (this._translateMessage) {
                ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
                alertMessage = LanguageUtil.get(this.request, resourceBundle, this._message);
            }
            return alertMessage;
        }
        return this._getBodyContentString();
    }

    private String _getAlertStyle() {
        if (this._key != null && Validator.isNull(this._message)) {
            return "danger";
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (SessionErrors.contains(portletRequest, "warning")) {
            return "warning";
        }
        return "danger";
    }

    private String _getAlertTitle() {
        if (this._key != null && Validator.isNull(this._message)) {
            return LanguageUtil.get(this.request, "error-colon");
        }
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (SessionErrors.contains(portletRequest, "warning")) {
            return LanguageUtil.get(this.request, "warning-colon");
        }
        return LanguageUtil.get(this.request, "error-colon");
    }

    private String _getBodyContentString() {
        if (this.bodyContent != null) {
            return this.bodyContent.getString();
        }
        return "";
    }

    private boolean _isShowAlert() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (this._key != null && Validator.isNull(this._message)) {
            return SessionErrors.contains(portletRequest, this._key) && Validator.isNotNull(this._getBodyContentString());
        }
        if (SessionErrors.contains(portletRequest, "warning")) {
            return true;
        }
        if (this._key == null) {
            return true;
        }
        return SessionErrors.contains(portletRequest, this._key);
    }
}

