/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.portletdisplaytemplate.PortletDisplayTemplateManagerUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BreadcrumbTag
extends IncludeTag {
    private static final String _PAGE = "/html/taglib/ui/breadcrumb/page.jsp";
    private long _ddmTemplateGroupId;
    private String _ddmTemplateKey;
    private boolean _showCurrentGroup = true;
    private boolean _showGuestGroup;
    private boolean _showLayout = true;
    private boolean _showParentGroups = true;
    private boolean _showPortletBreadcrumb = true;

    public long getDdmTemplateGroupId() {
        return this._ddmTemplateGroupId;
    }

    public String getDdmTemplateKey() {
        return this._ddmTemplateKey;
    }

    public boolean isShowCurrentGroup() {
        return this._showCurrentGroup;
    }

    public boolean isShowGuestGroup() {
        return this._showGuestGroup;
    }

    public boolean isShowLayout() {
        return this._showLayout;
    }

    public boolean isShowParentGroups() {
        return this._showParentGroups;
    }

    public boolean isShowPortletBreadcrumb() {
        return this._showPortletBreadcrumb;
    }

    public void setDdmTemplateGroupId(long ddmTemplateGroupId) {
        this._ddmTemplateGroupId = ddmTemplateGroupId;
    }

    public void setDdmTemplateKey(String ddmTemplateKey) {
        this._ddmTemplateKey = ddmTemplateKey;
    }

    public void setShowCurrentGroup(boolean showCurrentGroup) {
        this._showCurrentGroup = showCurrentGroup;
    }

    public void setShowGuestGroup(boolean showGuestGroup) {
        this._showGuestGroup = showGuestGroup;
    }

    public void setShowLayout(boolean showLayout) {
        this._showLayout = showLayout;
    }

    public void setShowParentGroups(boolean showParentGroups) {
        this._showParentGroups = showParentGroups;
    }

    public void setShowPortletBreadcrumb(boolean showPortletBreadcrumb) {
        this._showPortletBreadcrumb = showPortletBreadcrumb;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._ddmTemplateGroupId = 0L;
        this._ddmTemplateKey = null;
        this._showCurrentGroup = true;
        this._showGuestGroup = false;
        this._showLayout = true;
        this._showParentGroups = true;
        this._showPortletBreadcrumb = true;
    }

    protected List<BreadcrumbEntry> getBreadcrumbEntries(HttpServletRequest httpServletRequest) {
        List<BreadcrumbEntry> breadcrumbEntries = Collections.emptyList();
        ArrayList<Integer> breadcrumbEntryTypes = new ArrayList<Integer>();
        if (this._showCurrentGroup) {
            breadcrumbEntryTypes.add(1);
        }
        if (this._showGuestGroup) {
            breadcrumbEntryTypes.add(2);
        }
        if (this._showLayout) {
            breadcrumbEntryTypes.add(3);
        }
        if (this._showParentGroups) {
            breadcrumbEntryTypes.add(4);
        }
        if (this._showPortletBreadcrumb) {
            breadcrumbEntryTypes.add(5);
        }
        try {
            breadcrumbEntries = BreadcrumbUtil.getBreadcrumbEntries(httpServletRequest, ArrayUtil.toIntArray(breadcrumbEntryTypes));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return breadcrumbEntries;
    }

    protected String getDisplayStyle() {
        if (Validator.isNotNull(this._ddmTemplateKey)) {
            return PortletDisplayTemplateManagerUtil.getDisplayStyle(this._ddmTemplateKey);
        }
        return null;
    }

    protected long getDisplayStyleGroupId() {
        if (this._ddmTemplateGroupId > 0L) {
            return this._ddmTemplateGroupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay.getScopeGroupId();
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest httpServletRequest) {
        httpServletRequest.setAttribute("liferay-ui:breadcrumb:breadcrumbEntries", this.getBreadcrumbEntries(httpServletRequest));
        httpServletRequest.setAttribute("liferay-ui:breadcrumb:displayStyle", (Object)this.getDisplayStyle());
        httpServletRequest.setAttribute("liferay-ui:breadcrumb:displayStyleGroupId", (Object)this.getDisplayStyleGroupId());
    }
}

