/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.theme;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class MetaTagsTag
extends IncludeTag {
    private static final String _PAGE = "/html/taglib/theme/meta_tags/page.jsp";

    public static void doTag(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        MetaTagsTag.doTag(_PAGE, servletContext, httpServletRequest, httpServletResponse);
    }

    public static void doTag(String page, ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(page);
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected int processEndTag() throws Exception {
        ListMergeable pageKeywordsListMergeable;
        ListMergeable pageDescriptionListMergeable;
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return 6;
        }
        Layout layout = themeDisplay.getLayout();
        if (layout == null) {
            return 6;
        }
        String currentLanguageId = LanguageUtil.getLanguageId(httpServletRequest);
        String defaultLanguageId = LocaleUtil.toLanguageId(LocaleUtil.getSiteDefault());
        String w3cCurrentLanguageId = LocaleUtil.toW3cLanguageId(currentLanguageId);
        String w3cDefaultLanguageId = LocaleUtil.toW3cLanguageId(defaultLanguageId);
        String metaRobots = layout.getRobots(themeDisplay.getLanguageId(), false);
        String metaRobotsLanguageId = w3cCurrentLanguageId;
        if (Validator.isNull(metaRobots)) {
            metaRobots = layout.getRobots(defaultLanguageId);
            metaRobotsLanguageId = w3cDefaultLanguageId;
        }
        if (Validator.isNotNull(metaRobots)) {
            this._writeMeta(HtmlUtil.escape(metaRobots), metaRobotsLanguageId, "robots");
        }
        String metaDescription = layout.getDescription(themeDisplay.getLanguageId(), false);
        String metaDescriptionLanguageId = w3cCurrentLanguageId;
        if (Validator.isNull(metaDescription)) {
            metaDescription = layout.getDescription(defaultLanguageId);
            metaDescriptionLanguageId = w3cDefaultLanguageId;
        }
        if ((pageDescriptionListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION")) != null) {
            if (Validator.isNotNull(metaDescription)) {
                StringBundler sb = new StringBundler(4);
                sb.append(pageDescriptionListMergeable.mergeToString(" "));
                sb.append(".");
                sb.append(" ");
                sb.append(metaDescription);
                metaDescription = sb.toString();
            } else {
                metaDescription = pageDescriptionListMergeable.mergeToString(" ");
            }
        }
        if (Validator.isNotNull(metaDescription)) {
            this._writeMeta(HtmlUtil.escape(metaDescription), metaDescriptionLanguageId, "description");
        }
        String metaKeywords = layout.getKeywords(themeDisplay.getLanguageId(), false);
        String metaKeywordsLanguageId = w3cCurrentLanguageId;
        if (Validator.isNull(metaKeywords)) {
            metaKeywords = layout.getKeywords(defaultLanguageId);
            metaKeywordsLanguageId = w3cDefaultLanguageId;
        }
        if ((pageKeywordsListMergeable = (ListMergeable)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS")) != null) {
            if (Validator.isNotNull(metaKeywords)) {
                StringBundler sb = new StringBundler(4);
                sb.append(pageKeywordsListMergeable.mergeToString(","));
                sb.append(",");
                sb.append(" ");
                sb.append(metaKeywords);
                metaKeywords = sb.toString();
            } else {
                metaKeywords = pageKeywordsListMergeable.mergeToString(",");
            }
        }
        if (Validator.isNotNull(metaKeywords)) {
            this._writeMeta(HtmlUtil.escape(metaKeywords), metaKeywordsLanguageId, "keywords");
        }
        return 6;
    }

    private void _writeMeta(String content, String lang, String name) throws IOException {
        JspWriter jspWriter = this.pageContext.getOut();
        jspWriter.write("<meta content=\"");
        jspWriter.write(content);
        jspWriter.write("\" lang=\"");
        jspWriter.write(lang);
        jspWriter.write("\" name=\"");
        jspWriter.write(name);
        jspWriter.write("\" />");
    }
}

