/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.search.SearchEntry;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TextSearchEntry
extends SearchEntry {
    private Map<String, Object> _data;
    private String _href;
    private String _name;
    private String _target;
    private String _title;

    public Object clone() {
        TextSearchEntry textSearchEntry = new TextSearchEntry();
        BeanPropertiesUtil.copyProperties(this, textSearchEntry);
        return textSearchEntry;
    }

    public Map<String, Object> getData() {
        return this._data;
    }

    public String getHref() {
        return this._href;
    }

    public String getName() {
        return this._name;
    }

    public String getName(HttpServletRequest httpServletRequest) {
        return this.getName();
    }

    public String getTarget() {
        return this._target;
    }

    public String getTitle() {
        return this._title;
    }

    @Override
    public void print(Writer writer, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (Validator.isNull(this._href)) {
            writer.write(this.getName(httpServletRequest));
        } else {
            StringBundler sb = new StringBundler();
            sb.append("<a");
            if (this._data != null) {
                for (Map.Entry<String, Object> entry : this._data.entrySet()) {
                    String key = entry.getKey();
                    String value = String.valueOf(entry.getValue());
                    sb.append(" data-");
                    sb.append(key);
                    sb.append("=\"");
                    sb.append(value);
                    sb.append("\"");
                }
            }
            sb.append(" href=\"");
            if (this._href.startsWith("javascript:")) {
                sb.append(this._href);
            } else {
                sb.append(HtmlUtil.escape(this._href));
            }
            sb.append("\"");
            if (Validator.isNotNull(this._target)) {
                sb.append(" target=\"");
                sb.append(this._target);
                sb.append("\"");
            }
            if (Validator.isNotNull(this._title)) {
                sb.append(" title=\"");
                sb.append(this._title);
                sb.append("\"");
            }
            sb.append(">");
            sb.append(this.getName(httpServletRequest));
            sb.append("</a>");
            writer.write(sb.toString());
        }
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    public void setHref(String href) {
        this._href = href;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

