/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.search;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.taglib.search.TextSearchEntry;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class DateSearchEntry
extends TextSearchEntry {
    private Date _date;
    private Locale _locale;
    private TimeZone _timeZone;
    private String _userName;

    public Date getDate() {
        return this._date;
    }

    @Override
    public String getName(HttpServletRequest httpServletRequest) {
        if (this._date != null) {
            Object[] localeAndTimeZone = this.getLocaleAndTimeZone(httpServletRequest);
            Locale locale = (Locale)localeAndTimeZone[0];
            Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime(locale, (TimeZone)localeAndTimeZone[1]);
            StringBundler sb = new StringBundler(5);
            sb.append("<span onmouseover=\"Liferay.Portal.ToolTip.show(this, '");
            sb.append(dateFormatDateTime.format(this._date));
            sb.append("')\">");
            sb.append(LanguageUtil.format(locale, this._getMessageKey(), new Object[]{LanguageUtil.getTimeDescription(locale, this._getTimeDelta(), true), HtmlUtil.escape(this._userName)}, false));
            sb.append("</span>");
            return sb.toString();
        }
        return "";
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    protected Object[] getLocaleAndTimeZone(HttpServletRequest httpServletRequest) {
        if (this._locale != null && this._timeZone != null) {
            return new Object[]{this._locale, this._timeZone};
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._locale = themeDisplay.getLocale();
        this._timeZone = themeDisplay.getTimeZone();
        return new Object[]{this._locale, this._timeZone};
    }

    private String _getMessageKey() {
        if (this._date.before(new Date())) {
            if (this._userName == null) {
                return "x-ago";
            }
            return "x-ago-by-x";
        }
        if (this._userName == null) {
            return "within-x";
        }
        return "within-x-by-x";
    }

    private long _getTimeDelta() {
        if (this._date.before(new Date())) {
            return System.currentTimeMillis() - this._date.getTime();
        }
        return this._date.getTime() - System.currentTimeMillis();
    }
}

